#ifndef UTSUSEMIREDISPUBSUBEVENTCONTAINER_HH
#define UTSUSEMIREDISPUBSUBEVENTCONTAINER_HH

/* Header.hh should be included on the top to avoid environments
 * specific issues (see Header.hh for the detail).
 */
#include "Header.hh"

#include "UtsusemiHeader.hh"
#include "UtsusemiRedisPubSubEventReader.hh"
#include <boost/filesystem.hpp>
#include <boost/foreach.hpp>

///////////////////////////////////////////
//  UtsusemiRedisPubSubEventContainer
///////////////////////////////////////////

//! Queue PubSub access for Event Data
/*!
 *
 *   tt=QM.UtsusemiRedisPubSubEventContainer()
 *   tt.Subscribe( "SIK", runNo, daqId, modNo, "localhost", 2223 )
 *   tt.Read()
 *   tt.Unsubscribe()
 *
 *   ret=tt.Test( "SIK", runNo, daqId, modNo, "Test.bin","localhost", 2223)
 */
class UtsusemiRedisPubSubEventContainer
{
public:

    UtsusemiRedisPubSubEventContainer();
    ~UtsusemiRedisPubSubEventContainer();

    bool Initialize( std::string instCode, UInt4 runNo, UInt4 daqId, UInt4 modNo, std::string host="localhost", UInt4 port=6379, std::string date="" );
    bool Reset();

    bool Update();

    bool SetReference( std::vector<UInt8> *pulseId, std::vector< std::vector<UInt4>* > *caseList=NULL );
    bool Put( UChar *data, UInt4 *num_of_data, std::vector<UInt8> *t0PulseId, std::vector<Double> *t0DiffClock, std::vector<UInt8> *t0Index, std::vector< std::vector<UInt4>* > *caseList );

    std::vector<UInt8> PutPulseIdTable(){ return LeftPulseIdTable; }
    std::vector<UInt8> PutT0IndexTable(){ return LeftT0IndexTable; }
    UInt4 PutEventSize(){ return LeftEdbEvents.size(); }
    std::pair<Double,Double> MeasClockSliced;
    std::pair<Double,Double> CurrentClockSliced;
    bool isInitialized(){ return _isSubscribed; }
    bool isDebug;
protected:
    std::vector<UInt8> LeftPulseIdTable;
    std::vector<UInt8> LeftT0IndexTable;
    std::vector<Double> LeftDiffClockTable;
    std::vector<Char>  LeftEdbEvents;

    std::vector<UInt8> *PulseIdOfCases;
    std::vector< std::vector<UInt4>* > *CaseList;

    std::string _MessageTag;
    UInt4 _ByteOfEvent;
    bool _isSubscribed;

private:
    UtsusemiRedisPubSubEventReader* _Reader;

};

#endif
