# Utsusemi software environment 
# (2022.11.22)

# Delete old settings
unset MLFSOFT_PATH
unset MANYO_PATH

unset UTSUSEMI_BASE_DIR
unset UTSUSEMI_SYS_NAME
unset UTSUSEMI_DATA_DIR
unset UTSUSEMI_USR_DIR
unset UTSUSEMI_USR_PRIV_HOME
unset UTSUSEMI_MULTH
unset UTSUSEMI_BASE_PATH

unalias Ana > /dev/null 2>&1
unalias AnaQ > /dev/null 2>&1

# Utsusemi Environment
export UTSUSEMI_INST_CODE=SAS
export UTSUSEMI_DATA_DIR=/data
export UTSUSEMI_USR_DIR=${UTSUSEMI_USR_DIR-${HOME}}
export UTSUSEMI_WORK_DIR=${UTSUSEMI_USR_DIR}
export UTSUSEMI_LOG_QUIET=n
export UTSUSEMI_MULTH=8
export UTSUSEMI_DEBUGMODE=n
export MLF_T0PIDCHECK_IGNORED=y

# Path to MLF Software
MLFSOFT_PATH=/opt/mlfsoft

# Path to Manyo-lib
export MANYO_PATH=${MLFSOFT_PATH}/manyo

# PythonPath to utsusemi
PYUTSUSEMI_PATH=${MLFSOFT_PATH}/python-utsusemi

# PythonPath to uGao
PYUGAO_PATH=${MLFSOFT_PATH}/python-ugao

# External Library path
UTSUSEMI_EXT_LIBRARY_PATH=/usr/local/lib

# Utsusemi Environment
export UTSUSEMI_BASE_DIR=${PYUTSUSEMI_PATH}/utsusemi

# Python Path
PYTHONPATH=${MANYO_PATH}:${PYUTSUSEMI_PATH}:${UTSUSEMI_BASE_DIR}/facade
PYTHONPATH=${UTSUSEMI_BASE_DIR}/${UTSUSEMI_INST_CODE}/facade:${UTSUSEMI_USR_DIR}/facade:${PYTHONPATH}
PYTHONPATH=${PYTHONPATH}:${PYUGAO_PATH}
export PYTHONPATH

# Shared Library Path
export LD_LIBRARY_PATH=${MANYO_PATH}/lib:${UTSUSEMI_EXT_LIBRARY_PATH}:${LD_LIBRARY_PATH}

# Executable path
export PATH=${MANYO_PATH}/bin:${PATH}

echo '==========================================='
echo ' Welcome to Utsusemi Environment for '${UTSUSEMI_INST_CODE}
echo '                             ver 4.0'
echo '==========================================='
echo ' Ana   : Sequencer'
echo ' MPlot : MPlot (1d plotter)'
echo ' M2Plot: M2Plot (2d plotter M2Plot+)'
echo ' ubslicer : UB_Slicer'
echo '==========================================='

# Alias

function Ana(){
    python3 ${UTSUSEMI_BASE_DIR}/ana/SequencerQ.py -file=$@ &
}
alias MPlot='python3 '${UTSUSEMI_BASE_DIR}'/../uGao/MPlot.py &'
alias M2Plot='python3 '${PYUGAO_PATH}'/uGao/M2PlotPlus.py &'
alias ubslicer='python3 '${UTSUSEMI_BASE_DIR}'/'${UTSUSEMI_INST_CODE}'/vis/UBSlicer.py &'
