#!/usr/bin/python3
# -*- coding: utf-8 -*-
"""

"""
import Cmm
import sys

start = int(sys.argv[1])
end = int(sys.argv[2])

for run in range(start, end+1):
    DAT = Cmm.GetHistogramSAS(run, "lambda2", "0.7 7.6 0.01", "BW", "-1 -1", 0.0, False)
    EC = Cmm.GetMonHistSAS(run, 1, "lambda2", "0.7 7.6 0.01", 0, "-1 -1", 0.0, True)
    Cmm.I0LambdaCorrection(DAT, EC)
    Cmm.ConvertQSpace(DAT, "0.0 0.0 1.0")
    Iq = Cmm.SectorAverageByAngles(DAT, "BW", "0.1 15 0.01", "0.7 7.6", "0.0 0.0", "0.0 0.0")
    Iq[0].SaveTextFile("SAS%06d_BW.dat"%run, 6)

