#ifndef		_FTLCALCDETECTOREFFI_H
#define		_FTLCALCDETECTOREFFI_H

#include "Header.hh"
#include <pthread.h>
#include <semaphore.h>
#include <string>
using namespace std;


#define IS_TEST_MODE	(1)

#define N_INTG_NUM	(1000)

//#define C_FTL_DW_DELTA	(1.0/10.0)
#define C_FTL_DW_DELTA	 (1.0/100.0)
//#define C_FTL_DW_DELTA	 (1.0/500.0)
//#define C_FTL_DW_DELTA	 (1.0/1000)

// Lambda
#define	C_FTL_DW_LAMBDA_MAX			 	(15.0f)
#define	C_FTL_DW_LAMBDA_MIN			 	(0.0f)
#define	C_FTL_DW_LAMBDA_GAP			 	C_FTL_DW_DELTA
#define	C_FTL_N_LAMBDA_INTERVAL_NUM		(int)((C_FTL_DW_LAMBDA_MAX - C_FTL_DW_LAMBDA_MIN)/C_FTL_DW_LAMBDA_GAP)

// SEC = ArcCos
#define	C_FTL_DW_SEC_MAX			 	(2.0f)
#define	C_FTL_DW_SEC_MIN			 	(1.0f)
#define	C_FTL_DW_SEC_GAP			 	C_FTL_DW_DELTA
#define	C_FTL_N_SEC_INTERVAL_NUM		(int)((C_FTL_DW_SEC_MAX - C_FTL_DW_SEC_MIN)/C_FTL_DW_SEC_GAP)

typedef struct 
{
	string strSusTypeName;
	string strDetectorFilePathName;	// Full Path
	double dwRadius;				// 
	double dwDepth;					// 
	double dwN3He;					// number dencity of 3He
	double dwSigAbsHe;				// absorption cross-section of He
	double dwN_Sus;					// number dencity of SUSi
	double dwSigAbsSus;				// absorption cross-section of SUS
	double dwSigScttSus;			// scatting   cross-section of SUS
	double dwPrmA;
	double dwPrmB;
	double dwPrmC;
}
STRCT_SUS_INFO;


class FtlCalcDetectorEffi
{
private:
	void CalcBuf(void);
	static void *thread_function(void *thdata);
	double	dwResultBox[C_FTL_N_LAMBDA_INTERVAL_NUM][C_FTL_N_SEC_INTERVAL_NUM];
	double	dwLoadBox[C_FTL_N_LAMBDA_INTERVAL_NUM][C_FTL_N_SEC_INTERVAL_NUM];

	double	dwCalcInteg(double dwLambda, double dwSec);
	static STRCT_SUS_INFO stSusInfo;
public:
	void saveData(string strFullPath, string strSusType);
	bool loadData(string strFullPath);
	void outputSampleData(void);
	
	void SetPrm(
		double dwRadius,	// radius of PSD
		double dwDepth,		// thickness of PSD
		double dwN3He,		// number dencity of 3He
		double dwSigAbsHe,	// absorption cross-section of He
		double dwN_Sus,		// number dencity of SUSi
		double dwSigAbsSus,	// absorption cross-section of SUS
		double dwSigScttSus	// scatting   cross-section of SUS
	);

	// Constructor
	FtlCalcDetectorEffi();
	// Destructor
	~FtlCalcDetectorEffi();
	
	double PutApproximateVal(double lambda,double sec);
	void makeData(void);
#if IS_TEST_MODE 
	void doIntegTest(void);
#endif	
};


#endif /* _CALCDETECTOREFFI_H */
