#ifndef RPMTSETMASKBY2THETA
#define RPMTSETMASKBY2THETA

#include <math.h>
#include "StringTools.hh"
#include "UtsusemiHeader.hh"
#include "UtsusemiAnaEnvironReader.hh"
#include "SASDetectorInfoEditorRPMT.hh"

//////////////////////////////////
// RPMTSetMaskBy2theta
/////////////////////////////////

//! Make pixels on RPMT masked by given 2thea(polar angle) from drifting center position with a gravity
/*!
 *  Gravity parameter -b*(lambda)^2
 *  where b is imported from DetectorInfo by runNo in given data
 *
 *
 */
class RPMTSetMaskBy2theta :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    std::string _MessageTag;
    UtsusemiAnaEnvironReader* _AE;
    bool _Status;
    UInt4 _runNo;
    bool _isOutSide;
    Double _angle;

public:
    RPMTSetMaskBy2theta();
        //!< Constructor
        /*!<
         */
    RPMTSetMaskBy2theta(ElementContainerMatrix *ecm, Double angle=-1.0, bool isOutSide=true );
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         *  @param angle (double)
         *  @param isOutSide (bool)
         */
    ~RPMTSetMaskBy2theta();
        //!< Destructor
        /*!<
         */
    bool SetRunNo(UInt4 runNo=0);
    bool SetAngle(Double angle, bool isOutSide=true);
        //!< Set parameter
        /*!<
         *   @param None
         *   @retval true   done successfully
         *   @retval false  failed
         */
    bool Execute();
        //!< Set Mask
        /*!<
         *   @param None
         *   @retval true   done successfully
         *   @retval false  failed
         */
    bool Status(){ return _Status; }
};
#endif
