#ifndef SASRPMTDATACONVERTER
#define SASRPMTDATACONVERTER

#include "Header.hh"
#include "CppToPython.hh"
#include "ManipulatorBase.hh"
#include "ElementContainerMatrix.hh"
#include "UtsusemiHeader.hh"
#include "UtsusemiAnaEnvironReader.hh"
#include "SASDetectorInfoEditorRPMT.hh"
#include "StringTools.hh"

///////////////////////////////////
/// RPMT Data Converter
///////////////////////////////////

class RPMTDataConverter
{
private:
    UInt4 _EventSize;           /**< size of a event (8[bytes] or 4[bytes]) */
    /* common information */
    UChar _HeaderT0Event;       /**< Header Charactor of T0 Event */
    UChar _HeaderClockEvent;    /**< Header Charactor of Instrument Clock Event */
    UChar _HeaderNeutronEvent;  /**< Header Charactor of Neutron Event */
    UInt4 _MaxPHA;
    UInt4 _numOfLines;  /** the number of lines on a axis of RPMT */
    UInt4 _binWidth;
    //Double _rotAngle; //for rotation but ignored
    UInt4 _size_Xch;
    UInt4 _size_Ych;
    Int4 _XchShift;
    Int4 _YchShift;
    UInt4 _XchOffset;
    UInt4 _YchOffset;
    UInt4 _XCHPSDNO;
    UInt4 _YCHPSDNO;
    UInt4 _LLD_X;
    UInt4 _LLD_Y;
    UInt4 _HLD_X;
    UInt4 _HLD_Y;

    UInt4 _DaqId;

    std::string _MessageTag;
    StringTools* _st;
    void _addPath( std::string *orgPath, std::string *addPath );

public:
    RPMTDataConverter();
    ~RPMTDataConverter();

    void SetDaqId( UInt4 daqId ){ _DaqId=daqId; }
    void SetBinWidth( UInt4 bins );
    void SetChannelSize( UInt4 x_size, UInt4 y_size=0 );
    bool SetChannelShift(Int4 xadd, Int4 yadd);
    bool SetParamsFromAnaEnv(UInt4 runNo, UInt4 modeNo,std::string wfile="",std::string dfile="");
    std::vector<UInt4> DecodeOneEvent( const UChar *data, UInt4 LLD_X, UInt4 HLD_X, UInt4 LLD_Y, UInt4 HLD_Y );
    void EncodeNeutronEvent( UChar *data, UInt4 TOF_clock, UInt4 X_ch, UInt4 Y_ch );
    void ReplaceModuleNo( UChar *data, UInt4 modNo );
    bool Execute( std::vector<std::string> orgfiles, std::string outdir, UInt4 runNo, UInt4 LLD_X=0, UInt4 HLD_X=0, UInt4 LLD_Y=0, UInt4 HLD_Y=0, UInt4 LmtCoin=32 );
    bool PutPulseHeight(ElementContainer* ecX, ElementContainer* ecY, std::vector<std::string> orgfiles, UInt4 width_bin=1, UInt4 max_bin=2048, UInt4 LmtCoin=32);
};
#endif


