#ifndef SASQZPROJECTION
#define SASQZPROJECTION

#include "Header.hh"
#include "CppToPython.hh"
#include "ManipulatorBase.hh"
#include "ElementContainerMatrix.hh"
#include "UtsusemiHeader.hh"

//////////////////////////////////
// Projection of Qz for Analysis on SAS
/////////////////////////////////

//! Function to do the projection along Qz and make std::map data
/*!
 *
 *
 *
 *
 */

class QzProjection :
    public ManipulatorBase< ElementContainerMatrix >
{
private:
    std::vector<double> _QxBin;
    std::vector<double> _QyBin;
    std::pair<double,double> _QxRange;
    std::pair<double,double> _QyRange;
    std::pair<double,double> _QzRange;
    std::pair<double,double> _LambRange;
    double _QxBinWidth;
    double _QyBinWidth;
    std::vector<UInt4> _bankIdList;

    std::vector< std::vector<double> > _IQ;
    std::vector< std::vector<double> > _Error;
    std::vector< std::vector<double> > _Count;
    std::pair<double,double> MakeBinsZeroCenter( double s_val, double e_val, double step );
    void Initialize();
    std::string _MessageTag;

public:
    QzProjection();
    QzProjection( ElementContainerMatrix* ecm );
    ~QzProjection();

    void SetMapRange( double qx_min, double qx_max, double qx_bin,
                      double qy_min, double qy_max, double qy_bin );
    void SetQzRange( double qz_min, double qz_max );
    void SetLambRange( double lamb_min, double lamb_max );
    bool AddBankId( UInt4 bankId );
    void ClearBankIdList(){ _bankIdList.clear();}
    void Execute();

    void SetResultAsECM( ElementContainerMatrix* ecm );
    void SetResultAsECA( ElementContainerArray* eca );
    UInt4 PutNumOfQxBin(){return _QxBin.size(); }
    UInt4 PutNumOfQyBin(){return _QyBin.size(); }
    PyObject* PutListOfIntAlongQx( UInt4 indx );
    PyObject* PutListOfErrAlongQx( UInt4 indx );

};
#endif
