#ifndef I0LAMBDACORRECTION
#define I0LAMBDACORRECTION

#include "ManipulatorBase.hh"
#include "ElementContainerMatrix.hh"
#include "UtsusemiHeader.hh"

////////////////////////////////////////
// Correct ECM using EC of I0(lambda)
////////////////////////////////////////

//! Function to correct ElementContainerMatrix using EC of I0(lambda)
/*!
 *   # Usage
 *   # DAT : ElementContainer, EC : I0 data
 *   I0corr = I0LambdaCorrection(DAT)
 *   if I0corr.Execute( EC ):
 *       .. Succeeded ..
 *
 *   # When using of lambda dependency of polarization ratio
 *   if I0corr.Execute( EC, "path/to/PolFile.txt" ):
 *       .. Succeeded ..
 *
 */
class I0LambdaCorrection:
public ManipulatorBase<ElementContainerMatrix>{
private:
    ElementContainer i0Lambda; /**< EC of I0(Lambda) */
    bool calcErrorPropagation;
    std::vector<Double> _pol_lam; /**< lamda value of PolarizationTable data    */
    std::vector<Double> _pol_val; /**< ratio value of PolarizationTable data    */
protected:
    const std::string MessageTag;

    bool _ExecPolarizationCorrection( ElementContainerMatrix*, std::vector<Double>,  std::vector<Double> );
public:
    I0LambdaCorrection();
        //!< Constructor
        /*!<
         */
    I0LambdaCorrection(ElementContainerMatrix* ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */

    virtual void SetI0Lambda(ElementContainer  ec);
        //!< Sets EC of I0(lambda)
        /*!<
         *  @param ec ElementContainer of I0(lambda)
         */
    virtual bool SetPolarizationTable( std::string _pathToData );
        //!< Set text file path for Polarization table
        /*!<  text format  <lambda>,<polarization>
         *    If the beginning of line is #, ignored
         *  @param _pathToData (std::string) path to text file
         *  @retval true  : succeeded.
         *  @retval false : failed.
         */
    virtual void SetErrorPropagation(bool errProp=false){this->calcErrorPropagation = errProp;};
        //!< Sets a flag to calculate error propagation
        /*!<
         *  @param errProp flag to calculate error propagation
         */
    virtual bool Execute(ElementContainer ec, std::string _pathToData="" );
        //!< Sets EC of I0(lambda) and corrects ECM using it
        /*!<
         *  @param ec (ElementContainer) data of I0(lambda)
         *  @param _pathToData (std::string) full path of the polarization data
         */
    virtual bool Execute();
        //!< Corrects ECM using set EC
        /*!<
         *
         */
};
#endif
