#include "EcmSubtraction.hh"

////////////////////////////////////////
EcmSubtraction::
EcmSubtraction():
    MessageTag ("ECM subtraction>> "){
}

////////////////////////////////////////
EcmSubtraction::
EcmSubtraction(ElementContainerMatrix* ecm0):
    MessageTag ("ECM subtraction>> "){
    SetInputP(ecm0);
}

////////////////////////////////////////
bool EcmSubtraction::
Subtract(ElementContainerMatrix *ecm1){
    ElementContainerMatrix *ecm0 = PutInput();

    bool ret = false;

    HeaderBase hh0 = ecm0->PutHeader();
    ElementContainerMatrix* ret_ecm = new ElementContainerMatrix(hh0);
    SetOutput(ret_ecm);
    HeaderBase * ret_hh = ret_ecm->PutHeaderPointer();
    std::vector<std::string> process = ret_hh->PutStringVector("DATAPROCESSED");

    std::cout << MessageTag << "Processing ";
    Int4 ecm0_size = ecm0->PutSize();
    for (UInt4 i=0; i< ecm0_size; ++i){
        std::cout << ".";
        ElementContainerArray eca0 = ecm0->Put(i);
        Int4 det_id0 = eca0.PutHeaderPointer()->PutInt4("DETID");

        SearchInHeader SS(ecm1);
        SS.SearchArray("DETID", det_id0);
        std::vector<UInt4> srch_rslt = SS.PutResultIndex(0);
        if (srch_rslt.size() != 0){
            ElementContainerArray eca1 = ecm1->Put(srch_rslt[0]);
            ret_ecm->Add( eca0 - eca1 );
        } else {
            std::cout << "Not found. DETID " << det_id0 << std::endl;
        }
    }
    std::cout << std::endl;

    process.push_back("EcmSubtraction");
    ret_hh->OverWrite("DATAPROCESSED",process);

    return true;
}

