#ifndef SASDETECTOREFFICORRECTIONRPMT
#define SASDETECTOREFFICORRECTIONRPMT

#include "Header.hh"
#include "ManipulatorBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "HeaderBase.hh"
#include "UtsusemiUnitConverter.hh"

//////////////////////////////////
// PRMT Detector Efficiency Correction for Analysis on SAS
/////////////////////////////////

//! Function to do correction of the detector efficiency
/*!
 *
 *
 *
 *
 */
class DetectorEffiCorrectionRPMT :
    public ManipulatorBase< ElementContainerMatrix >
{
private:
    void Initialize();
    std::string _MessageTag;
    std::vector<Double> _params;

public:
    DetectorEffiCorrectionRPMT();
    DetectorEffiCorrectionRPMT( ElementContainerMatrix *ecm );
    ~DetectorEffiCorrectionRPMT();

    bool SetParamsFormula1( Double alpha, Double beta );
        //!< Sets parameters for the wavelangth dependency of detection efficiency
        /*!< n(lambda) = (1-exp(-alpha*lambda))*exp(-beta*lambda)
         *
         *   @param alpha  (ElementContainer)
         *   @param beta   (double) pressure of N2 gas [atm]
         *   @return None
         */
    static bool Formula1( ElementContainerMatrix* ecm, std::vector<Double> params );
    bool (*formula)(ElementContainerMatrix* , std::vector<Double> );

    bool Execute();

};
#endif
