#ifndef SASDETECTOREFFICORRECTION
#define SASDETECTOREFFICORRECTION

#include "Header.hh"
#include "ManipulatorBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "HeaderBase.hh"
#include "UtsusemiUnitConverter.hh"
#include "SASCalcDetectorEffi.hh"

//////////////////////////////////
// Detector Efficiency Correction for Analysis on SAS
/////////////////////////////////

//! Function to do correction of the detector efficiency
/*!
 *
 *
 *
 *
 */
class DetectorEffiCorrection :
    public ManipulatorBase< ElementContainerMatrix >
{
private:
    void Initialize();
    //FtlCalcDetectorEffi* _FCD;
    SASCalcDetectorEffi* _FCD;
    std::string _EffiDataFilePath;
    std::string _MessageTag;

public:
    DetectorEffiCorrection();
    DetectorEffiCorrection( ElementContainerMatrix *ecm );
    DetectorEffiCorrection( ElementContainerMatrix *ecm, std::string filepath );
    ~DetectorEffiCorrection();
    void LoadEffiData( std::string filepath );
    Double CalcSecAtPixel( std::vector<Double> *det_unit_vec, std::vector<Double> *pixel_ori_vec );
    void Execute();
    void N2MonEffiCorrection( ElementContainer* ec, double p_N2, double thickness=12, double thick_Al=0.5 );
        //!< N2 Monitor detector efficiency correction
        /*!<
         *   @param ec        (ElementContainer)
         *   @param p_N2      (double) pressure of N2 gas [atm]
         *   @param thickness (double) thickness of monitor [mm]
         *   @param thick_Al  (double) thickness of Al window [mm]
         *   @return None
         */

};
#endif
