#ifndef SASCREATELAMBVECTOR
#define SASCREATELAMBVECTOR

#include "Header.hh"
#include "OperatorBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "HeaderBase.hh"
#include "UtsusemiUnitConverter.hh"
#include "UtsusemiReductionCommon.hh"

//////////////////////////////////
// Create Lambda vector for Analysis on SAS
/////////////////////////////////

//! Function to make Lambda vector and add to ElementContainer
/*!
 *
 *
 *
 *
 */
class CreateLambVector :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    void Initialize();
    std::vector<Double> CalcLambFromTof( HeaderBase* head_ec, std::vector<Double> tof, bool isHist=false );
    std::vector<Double> CalcLambFromEnergy( HeaderBase* head_ec, std::vector<Double> energy, bool isHist=false );
    std::vector<Double> CalcLambFromQ( HeaderBase* head_ec, std::vector<Double> moment, bool isHist=false );
    Double L1;                    /**< [mm] */
    std::string _MessageTag;
    UtsusemiUnitConverter* UU;    /**< UnitConversion Class    */

public:
    CreateLambVector();
        //!< Constructor
        /*!<
         */
    CreateLambVector(ElementContainerMatrix *ecm, Double L1_in=0.0 );
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    ~CreateLambVector();
        //!< Destructor
        /*!<
         */
    void SetL1( Double L1_in );
        //!< Sets L1 for calculation of lambda
        /*!<
         *   @param None
         *   @reurn None
         */
    bool Execute();
        //!< Executes creation of Lamb Vector
        /*!<
         *   @param None
         *   @retval true   done successfully
         *   @retval false  failed
         */
    void CalcSphericalAngles( double dx=0.0, double dy=0.0, double dz=0.0);
        //!< Executes calculation of poler angle and azimuth angle
        /*!<
         *   @param dx (double) delta x at a pixel
         *   @param dy (double) delta y at a pixel
         *   @param dz (double) delta z at a pixel
         *   @return None
         */
};
#endif
