from __future__ import print_function

import sys
import os
import Manyo as mm

if len(sys.argv) != 4:
    print("Usage: %s serialized_ecm_path pixel_id output_file"%sys.argv[0])
    print("Note:")
    print("")
    sys.exit()

input_path = sys.argv[1]
pixel_id = int(sys.argv[2])
output_path = sys.argv[3]

if not os.path.exists(input_path):
    print("[x] File not exist.")
    sys.exit()

ecm = mm.ElementContainerMatrix()
boostRead = mm.ReadSerializationFileBinary(input_path)
boostRead.Load(ecm)

si = mm.SearchInHeader()
si.SetTarget(ecm)
si.Search("PIXELID", pixel_id)
res_vect = si.PutResults()
ecm(res_vect[0][0], res_vect[0][1]).SaveTextFile(output_path, 6, ",")

