#ifndef EMAKIREADOUT1DEVENTDECODER
#define EMAKIREADOUT1DEVENTDECODER

#include "UtsusemiReadoutEventDecoderTemplate.hh"
#include "EmakiDetectorInfoEditorReadout.hh"
#include "WiringInfoEditorReadout.hh"

//////////////////////////////////
// EmakiReadout1dEventDecoder
/////////////////////////////////

//! Decode Event Data of Readout (1d) for Utsusemi
/*!
 *
 */


class EmakiReadout1dEventDecoder:
    public UtsusemiReadoutEventDecoderTemplate<WiringInfoEditorReadout,EmakiDetectorInfoEditorReadout>
{
private:
    std::string _MessageTag;  /**<  Message Tag */

protected:

    void Initialize();
        //!< Initialize some parameters
        /*!<
         *   @return None
         */

public:
    EmakiReadout1dEventDecoder();
        //!< Constructor
        /*!<
         */
    ~EmakiReadout1dEventDecoder();
        //!< Destructor
        /*!<
         */


    //////////////////////////////////////////////////////////////////////////
    // public instances
    //////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////
    // virtual functions from UtsusemiNeutronEventDecorderBase
    //////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////
    // virtual functions required by UtsusemiEventDataConverterTemplate
    //////////////////////////////////////////////////////////////////////////
    virtual UInt4 DecodeEventData( UInt4 daqId, UInt4 moduleNo, const UChar *data, UInt4 *pixel_id, double *tof, std::vector<Double>* Clock, UInt4 ThNum );
        //!< decode Event data
        /*!< This decodes any one event data and return type of event.
         *   If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent)
         *   If T0 event, this event is stored and return 2 (_isT0Event)
         *   If clock event, return 3
         *   If any other event, return 0
         *   @param daqId (UInt4) daq ID
         *   @param moduleNo (UInt4) module number
         *   @param data  (UChar) one event data
         *   @param pixel_id (UInt4) Pixel ID calculated by given event
         *   @param tof (double) TOF calculated by given event
         *   @param Clock (std::vector<Double>)
         *   @param ThNum (UInt4) Thread number
         *   @retval _isNeutronEvent if neutron event
         *   @retval _isT0Event if T0 event
         *   @retval _isClockEvent if clock event
         *   @retval 0 if any other event
         */
    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////

};

#endif
