#ifndef EMAKIEVENTDATACONVERTERREADOUT1D
#define EMAKIEVENTDATACONVERTERREADOUT1D

#include "UtsusemiEventDataConverterReadoutTemplate.hh"
#include "UtsusemiEventCasesDecoderTemplate.hh"
#include "EmakiReadout1dEventDecoder.hh"
#include "UtsusemiFilterTrignet.hh"
#include "StringTools.hh"
////////////////////////////////////////
// UtsusemiEventDataConverterReadout1d
////////////////////////////////////////

//! Load Event Data and convert to Histogram from 1d-scintillation counter
/*!
 *   LoadParamFiles( "WiringInfo.xml", "DetectorInfo.xml", "CaseInfo.xml" )
 *   LoadTrignetEventFile( runNo, "/data", "" )
 *   SetHistAllocation()
 *   ecm = ElementContainerMatrix()
 *   SetElementContainerMatrix( ecm, runNo, "/data", "" )
 */

class EmakiEventDataConverterReadout1d:
    public UtsusemiEventDataConverterReadoutTemplate< EmakiReadout1dEventDecoder,
                                               UtsusemiEventCasesDecoderTemplate<T0TreatToolsReadout,UtsusemiFilterTrignet>
                                               >
{
private:
    void Initialize();
    std::string _MessageTag;
    StringTools* stools;
    Int4 _SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 );
    UInt4 _NumOfMulTh;

public:
    EmakiEventDataConverterReadout1d();
        //!< Constructor
        /*!<
         */
    ~EmakiEventDataConverterReadout1d();
        //!< Destructor
        /*!<
         */

};
#endif
