#ifndef EMAKIDETECTORINFOEDITORREADOUT
#define EMAKIDETECTORINFOEDITORREADOUT

#include "DetectorInfoEditorBase.hh"
#include "StringTools.hh"
//////////////////////////////////
// EmakiDetectorInfoEditorReadout
/////////////////////////////////

//!
/*!
 *
 */
class EmakiDetectorInfoEditorReadout:
    public DetectorInfoEditorBase
{
private:

    DetectorInfoTagDefineBase TAG;
    std::string _MessageTag;
    StringTools* stools;

protected:
    void Initialize();

public:

    EmakiDetectorInfoEditorReadout();
        //!< Constructor
        /*!<
         */
    EmakiDetectorInfoEditorReadout( std::string dfile, bool workAsReader=true );
        //!< Constructor
        /*!<
         *   @param dfile (std::string) DetectorInfo file path to be read
         *   @param workAsReader (bool)
         */
    ~EmakiDetectorInfoEditorReadout();
        //!< Destructor
        /*!<
         */
    //////////////////////////////////////////////////////////////////////////
    // public variables
    //////////////////////////////////////////////////////////////////////////
    std::vector< Double > efficiencyParam; /**< std::vector of detection efficiency parameters */

    //////////////////////////////////////////////////////////////////////////
    // public functions
    //////////////////////////////////////////////////////////////////////////
    void Clear( UInt4 index=0 );
        //!< Clears stored parameters
        /*!<
         *   This deletes information by given index.
         *    index = 0 : all (default)
         *    index = 1 : InstrumentInfo
         *    index = 2 : TfpInfo
         *    index = 3 : TfpCalcParams
         *    index = 4 : PositionInfo
         *    index = 5 : BankInfo
         *
         *   @param index (UInt4)
         *   @return None
         */
    bool Read( std::string filepath );
        //!< Reads DetectorInfo.xml and import information
        /*!<
         *   @param filepath (std::string)
         *   @retval true : succeeded
         *   @retval false: failed
         */
    bool Write( std::string filepath );
        //!< Writes DetectorInfo.xml
        /*!<
         *   @param filepath (std::string)
         *   @retval true : succeeded
         *   @retval false: failed
         */
    bool _makeOutputXmlReadout();
        //!< Makes XML format from stored information
        /*!<
         *   @param  None
         *   @retval true    succeded
         *   @retval false   failed
         */
    void ClearReader( UInt4 index=0 );
    bool SetInfoAsReader();
    bool ImportEfficiency();
};
#endif
