# -*- coding: utf-8 -*-
"""

"""

import utsusemi.vis.VisualModuleQBase as UVM

# 予約語の定義
vdm = None
vmp = None
vm2p = None
vcm = None

EC = None
DAT = None
ECM = None
ECA = None

###################################################
def DetectMap(matrix=DAT):
        """
        Display Detector Map
        @param  matrix [Def:DAT(ElementContainerMatrix)] ElementContainerMatrix Object
        @retval vdm
        """
        return UVM.DetectMap(matrix)

###################################################
def DetectMap2(matrix=DAT):
    """
    Display Detector Map
    @param  matrix [Def:DAT(ElementContainerMatrix)] ElementContainerMatrix Object
    @retval vm2p
    """
    return UVM.DetectMap2(matrix)

###################################################
def DetectMap2ChangeData(vm2p=vm2p, matrix=DAT):
    """
    Display Detector Map
    @param  vm2p [Def:(vis_retval)] Instance of 1D Plotter
    @param  matrix [Def:DAT(ElementContainerMatrix)] ElementContainerMatrix Object
    @retval None
    """
    UVM.DetectMapChangeData(vm2p, matrix)

###################################################
def MPlot(ec=EC):
        """
        Create 1D Plotter and Draw EC
        @param  ec [Def:EC(ElementContainer,ListOfEC)]  ElementContainer
        @param  psd      PSD No.
        @param  pixel    Pixel No.
        @retval vmp    Instance of Plotter
        """
        return UVM.MPlot(ec)

###################################################
def AddToMPlot(vmp=vmp, ec=EC):
        """
        Add EC to 1D Plotter
        @param  vmp [Def:(vis_retval)]     Instance of 1D Plotter
        @param  ec [Def:EC(ElementContainer)]      ElementContainer
        @retval None
        """
        UVM.AddToMPlot(vmp,ec)

###################################################
def EmptyMPlot():
        """
        Create 1D Plotter and Draw EC without data
        @param  None
        @retval vmp Instance of Plotter
        """
        return UVM.MPlot(None)

###################################################
def M2PlotPlus(matrix=ECA):
        """
        Create 2D Plotter and display 2D Map
        @param  matrix [Def:ECM(ElementContainerArray,ElementContainerMatrix)]  ElementContainerArray
        @retval vm2p  Instance of 2D Plotter
        """
        return UVM.M2PlotPlus(matrix)

###################################################
def ChangeDataM2Plot(vm2p=vm2p, matrix=ECA):
        """
        Change 2D Map of M2Plot
        @param  vm2p [Def:(vis_retval)]     Instance of 2D Plotter
        @param  matrix [Def:ECA(ElementContainerArray,ElementContainerMatrix)]  ElementContainerArray
        @retval None
        """
        UVM.ChangeDataM2Plot(vm2p, matrix)

###################################################
def EmptyM2PlotPlus():
    """
    Create 2D Plotter and display 2D Map without data
    @param  None
    @retval vm2p  Instance of 2D Plotter
    """
    return UVM.EmptyM2PlotPlus()

###################################################
def VisContM(matrix=DAT):
        """
        Visualize Controller
        @param  matrix [Def:DAT(ElementContainerMatrixInEla)]  ElementContainerMatrix
        @retval vcm   Instance of Controller
        """
        return UVM.VisContM(matrix)

###################################################
def AddToVisContM(vcm=vcm, matrix=DAT, tab="B"):
        """
        Add Matrix to Visual Controller
        @param  vcm [Def:(vis_retval)]     Instance of Visual Controller
        @param  matrix [Def:DAT(ElementContainerMatrixInEla)]  ElementContainerMatrix
        @param  tab     Tab ID
        @retval None
        """
        UVM.AddToVisContM(vcm, matrix, tab)

# 関数名登録ディクショナリ
_functions = {"DetectMap":DetectMap,
              "DetectMap2": DetectMap2,
              "MPlot":MPlot,
              "AddToMPlot":AddToMPlot,
              "EmptyMPlot":EmptyMPlot,
              "M2PlotPlus":M2PlotPlus,
              "ChangeDataM2Plot":ChangeDataM2Plot,
              "EmptyM2PlotPlus": EmptyM2PlotPlus,
              "VisContM":VisContM,
              "AddToVisContM":AddToVisContM
              }

_functionsOrder = [
    "DetectMap",
    "DetectMap2",
    "DetectMap2ChangeData",
    "MPlot",
    "AddToMPlot",
    "EmptyMPlot",
    "M2PlotPlus",
    "ChangeDataM2Plot",
    "VisContM",
    "AddToVisContM"
    ]

