# -*- coding: utf-8 -*-

#####################
## Command Sequence of Elastic Scan
#####################

# special reserved word for commands history
HISTORY = None
# reserved words for return value in this.
DAT = None
ECA = None
EC = None

import Manyo as mm
import Manyo.Utsusemi as mu
import utsusemi.DNA.ana.Reduction.ElasticScanBase as ES
import utsusemi.DNA.ana.Reduction.ElasticScanBaseMulth as ESMulth
import utsusemi.DNA.ana.Reduction.SearchPathDNA as SPD
import os
import re
import math
import datetime

#basepath="/usr/local/mlf/DNA/tmp/" T. Yamada Modified[130228]
#basepath="/home/dnaadmin/DNA/tmp/"
basepath = os.path.join(mu.UtsusemiEnvGetUserDir(), "DNA", "tmp") #[inamura 230330]

#search_dir="/home/dnaadmin/ana/setup"
search_dir=SPD.CheckForOutput("setup")
if search_dir=="":
    raise UserWarning("ElasticScan.py >> Not found setup directory.")
#########################################
def GetDataOfDNA(runNo=314,HwParam=" ",LambParam=" ",QParam=" ",TimeParam=" ",initFile="GetQEDataOfDNAElasticScan.ini",outputData="QE",fileTag="_"):
    """
    Load EventData and convert to QE map
    - GetHistogramHW(runNo,dHW,hw_min,hw_max,tof_offset,startTime,endTime)
    - DoMask(DAT)
    - ILambdaCorrDNA(dat,ec)
    - SolidAngleCorrDNA(dat)
    - CreateQEMap(dat,startQ,endQ,deltaQ)

    @param runNo        (int) Run Number
    @param HwParam      (string)
    @param LambParam    (string)
    @param QParam       (string)
    @param TimeParam    (string)
    @param initFile     (string)
    @param fileTag      (string)   
    @retval ECM      (ElementContainerMatrix)
    """
    return ES.GetDataOfDNA(runNo, HwParam, LambParam, QParam, TimeParam, initFile, outputData, fileTag,search_dir)

#########################################
def GetQETimeECMMulth(runNo=314,HwParam=" ",LambParam=" ",QParam=" ",TimeParam=" ",initFile="GetQEDataOfDNA.ini"):
    """
    Elastic Scan (DNA), Get Time dependent QE Map Data
    - DoQEMask
    - SliceQEall
    - ElasticScanGetIntegral
    - ElasticScanAxisChange

    @param ECA          (ElementContainer)
    @param QParam       (string)
    @param HwParam    (string)
    @retval ECM      (ElementContainerMatrix)
    """
    return ESMulth.GetQETimeECMMulth(runNo, HwParam, LambParam, QParam, TimeParam, initFile,search_dir)

#########################################

def GetQETimeECM(runNo=314,HwParam=" ",LambParam=" ",QParam=" ",TimeParam=" ",initFile="GetQEDataOfDNA.ini"):
    """
    Elastic Scan (DNA), Get Time dependent QE Map Data
    - DoQEMask
    - SliceQEall
    - ElasticScanGetIntegral
    - ElasticScanAxisChange

    @param ECA          (ElementContainer)
    @param QParam       (string)
    @param HwParam    (string)
    @retval ECM      (ElementContainerMatrix)
    """
    return ES.GetQETimeECM(runNo, HwParam, LambParam, QParam, TimeParam, initFile,search_dir)

#########################################

def ElasticScanQ2LnI(ecm=DAT,HwParam=" ",QParam=" ",initFile="GetQEDataOfDNA.ini"):
    """
    Elastic Scan (DNA), QE ElementContainer Data to Slice Q Intensity Data
    - DoQEMask
    - SliceQEall
    - ElasticScanGetIntegral
    - ElasticScanAxisChange

    @param ECM          (ElementContainerMatrix)
    @param HwParam    (string)
    @param QParam       (string)
    @retval ECA      (ElementContainerArray)
    """
    return ES.ElasticScanQ2LnI(ecm,HwParam,QParam,initFile,search_dir)

#########################################################################

def ElasticScanQ2LnIExt(ecm=DAT,eca=ECA,factor=1.0,HwParam=" ",QParam=" ",initFile="GetQEDataOfDNA.ini"):
    """
    Elastic Scan (DNA), QE ElementContainer Data to Slice Q Intensity Data
    - DoQEMask
    - SliceQEall
    - ElasticScanGetIntegral
    - ElasticScanAxisChange

    @param ecm          (ElementContainerMatrix)
    @param eca          (ElementContainerArray)
    @param factor          (float)
    @param HwParam    (string)
    @param QParam       (string)
    @retval ECA      (ElementContainerArray)
    """
    return ES.ElasticScanQ2LnIExt(ecm,eca,factor,HwParam,QParam,initFile,search_dir)

#########################################################################

def ElasticScanTotalIntensity(ecm=DAT,HwParam=" ",QParam=" ",initFile="GetQEDataOfDNA.ini"):
    """
    Elastic Scan (DNA), Time dependent of Total Intensity
    - DoQEMask
    - SliceQEall
    - ElasticScanGetIntegral
    - ElasticScanAxisChange

    @param ECM       (ElementContainerMatrix)
    @param HwParam    (string)
    @param QParam    (string)
    @retval EC       (ElementContainer)
    """
    return ES.ElasticScanTotalIntensity(ecm, HwParam, QParam, initFile,search_dir)

#########################################################################

def ElasticScanFit(eca=ECA,func="p1"):
    """
    Elastic Scan (DNA), Fitting loop

    @param ECA          (ElementContainerArray)
    @param func         (string)
    @retval DAT          (ElementContainer)
    """
    return ES.ElasticScanFit(eca,func)

#########################################################################

def ElasticScanCheckTemp(ec=EC,temptype="Si"):
    """
    Elastic Scan (DNA), Temperature reading

    @param ec          (ElementContainer)
    @param temptype    (int)
    @retval EC         (ElementContainer)
    """
    return ES.ElasticScanCheckTemp(ec,temptype)

#########################################################################
#T.Yamada [130121]
def ElasticScanCheckTempNew(ec=EC,temptype="Si"):
    """
    Elastic Scan (DNA), Temperature reading

    @param ec          (ElementContainer)
    @param temptype    (int)
    @retval EC         (ElementContainer)
    """
    return ES.ElasticScanCheckTempNew(ec,temptype)

#########################################################################

def ElasticScanXAxisChangeToTemp(ec1=EC,ec2=EC,TempParam=""):
    """
    Elastic Scan (DNA), Fitting loop

    @param ec1          (ElementContainer)
    @param ec2          (ElementContainer)
    @param TempParam    (string)
    @retval EC          (ElementContainer)
    """
    return ES.ElasticScanXAxisChangeToTemp(ec1, ec2, TempParam)

#########################################################################



#########################################################################

def ElasticScanFitCheck(eca=ECA,time=100.0,func="p1"):
    """
    Elastic Scan (DNA), check Fit result

    @param ECA          (ElementContainerArray)
    @param time         (float)
    @param func         (string)
    @retval EC          (ElementContainer)

    """
    return ES.ElasticScanFitCheck(eca,time,func)

#########################################################################

def ElasticScanDataCheck(eca=ECA,time=100.0):
    """
    Elastic Scan (DNA), check EC Data

    @param ECA          (ElementContainerArray)
    @param time         (float)
    @retval EC          (ElementContainer)

    """
    return ES.ElasticScanDataCheck(eca,time)

#########################################################################

def ElasticScanGetIntegral(dat,emin,emax):
    """
    Elastic Scan

    @param dat     (ElementContaienrArray)
    @param emin    (double)
    @param emax    (double)
    @retval EC     (ElementContainer)
    """
    return ES.ElasticScanGetIntegral(dat,emin,emax)

#########################################

def ElasticScanAxisChange(ec):
    """
    Elastic Scan

    @param ec     (ElementContaienr)
    @retval EC     (ElementContainer)
    """

    return ES.ElasticScanAxisChange(ec)

#########################################

def ElasticScanLnNormalize(ec,ec0):
    """
    Elastic Scan

    @param ec     (ElementContaienr)
    @param ec0     (ElementContaienr)
    @retval EC     (ElementContainer)
    """

    return ES.ElasticScanLnNormalize(ec,ec0)

##########################################

def OutputECText(ec, filename="es.txt"):
    """
    Output EC data to text file

    @param ec                     (ElementContainer)
    @param filename                    (string)
    """
    return ES.OutputECText(ec, basepath,filename)

##########################################

def ReadECM(filename=""):
    """
    @param filename  (string)

    @retval ecm      (ElementContainerMatrix)
    """
    return ES.ReadECM(basepath,filename)

##########################################

def OutputECM(ecm=DAT,filename=""):
    """
    @param ecm       (ElementContainerMatrix)
    @param filename  (string)

    @retval None
    """
    return ES.OutputECM(ecm,basepath,filename)

##########################################
#T.Yamada [130323]
def OutPutElasticScanECM(ecm):
    """
    @param ecm   (ElementContainerMatrix)
    """
    return ES.ElasticScanOutPut(ecm)

#T.YamadaEnd

##########################################


# Dictionary for entry the name of functions
_functions = {
               "GetDataOfDNA":GetDataOfDNA,
               "ElasticScanQ2LnI":ElasticScanQ2LnI,
               "ElasticScanQ2LnIExt":ElasticScanQ2LnIExt,
               "ElasticScanFit":ElasticScanFit,
               "ElasticScanFitCheck":ElasticScanFitCheck,
               "ElasticScanDataCheck":ElasticScanDataCheck,
               "ElasticScanTotalIntensity":ElasticScanTotalIntensity,
               "ElasticScanCheckTemp":ElasticScanCheckTemp,
               "ElasticScanCheckTempNew":ElasticScanCheckTempNew,
               "ElasticScanXAxisChangeToTemp":ElasticScanXAxisChangeToTemp,
               "GetQETimeECMMulth":GetQETimeECMMulth,
               "GetQETimeECM":GetQETimeECM,
               "OutputECText":OutputECText,
               "ReadECM":ReadECM,
               "OutputECM":OutputECM,
               "OutPutElasticScanECM":OutPutElasticScanECM
             }
         
