import Manyo as mm
import os
import shutil
import uGao.MPlot as mp
import utsusemi.DNA.ana.Reduction.DeConvolutionBase as DC

# special reserved word for commands history
HISTORY = None

# reserved words for return value in this.
DAT = None
ecs = None
EC = None
EC1 = None
EC2 = None
ret = None


################################################################################################################

def EditInitLorentzParam(NumOfLor = 2, omega = "", ene0 = "", val = ""):
    """
    @param NumOfLor      (int)
    @param omega      (string)
    @param ene0       (string)
    @param val        (string)
    @retval None
    """
    return DC.EditInitLorentzParam(NumOfLor, omega, ene0, val)

################################################################################################################

def MemDeconvolution(ecData=EC1, ecRes=EC2, memData = 1,NumOfLor = 2,Itteration = 10,MemThreshold = 1.0,savepath = "/usr/local/mlf/DNA/tmp/Mem/"):
    """
    @param ecData           (ElementContainer)
    @param ecRes            (ElementContainer)
    @param memData          (int)
    @param NumOfLor         (int)
    @param Itteration       (int)
    @param MemThreshold     (int)
    @param savepath         (string)
    @retval EC              (ElementContainer)
    """
    return DC.MemDeconvolution(ecData,ecRes,memData,NumOfLor,Itteration,MemThreshold,savepath)

################################################################################################################

def MemExecuteManual():
    """
    @retval None
    """
    return DC.MemExecuteManual()

################################################################################################################

def ReadECAndWriteText(ec,filename= "sTest"):
    """
    @param ec     (ElementContaienr)
    @param filename         (string)
    @retval None
    """
    return DC.ReadECAndWriteText(ec,filename)

################################################################################################################

def MemExecute(DataFileName = "sDET05",ResFileName = "sV_5",memData = 1,NumOfLor = 2,columnParam = "",Itteration = 10,MemThreshold = 1.0,savepath = "/usr/local/mlf/DNA/tmp/Mem/"):
    """
    @param DataFileName     (string)
    @param ResFileName      (string)
    @param memData          (int)
    @param NumOfLor         (int)
    @param columnParam      (string)
    @param Itteration       (int)
    @param MemThreshold     (int)
    @param savepath         (string)
    @retval None
    """
    return DC.MemExecute(DataFileName,ResFileName,memData,NumOfLor,columnParam,Itteration,MemThreshold,savepath)

################################################################################################################

def LoadFinalData(filename="outputSqe.txt",SaveDataPath = "/usr/local/mlf/DNA/tmp/Mem/",linenumber=6):
    """
    @param filename      (string)
    @param SaveDataPath  (string)
    @param linenumber       (int)
    @retval ec (ElementContainer)
    """
    return DC.LoadFinalData(filename,SaveDataPath,linenumber)

################################################################################################################

def LoadTextData(filename="TEMP6.DAT",SaveDataPath = "/usr/local/mlf/DNA/tmp/Mem/"):
    """
    @param filename      (string)
    @param SaveDataPath  (string)
    @retval ec (ElementContainer)
    """
    return DC.LoadTextData(filename,SaveDataPath)


################################################################################################################

def PrintFileNametype():
    """
    @retval None
    """
    return DC.PrintFileNametype()

################################################################################################################

def GslFFTDeconvolution(ecData=EC1, ecRes=EC2):
    """
    @param ecData           (ElementContainer)
    @param ecRes            (ElementContainer)
    @retval EC              (ElementContainer)
    """
    return DC.GslFFTDeconvolution(ecData, ecRes)

################################################################################################################

def GslFFTConvolution(ecData=EC1, ecRes=EC2):
    """
    @param ecData           (ElementContainer)
    @param ecRes            (ElementContainer)
    @retval EC              (ElementContainer)
    """
    return DC.GslFFTConvolution(ecData, ecRes)

################################################################################################################

def NumpyFFTDeconvolution(ecDet=EC1,ecRes=EC2):
    """
    @param ecDet            (ElementContainer)
    @param ecRes            (ElementContainer)
    @retval EC2           (ElementContainer)
    """
    return DC.NumpyFFTDeconvolution(ecDet,ecRes)

################################################################################################################


def NumpyFFTConvolution(ecDet=EC1,ecRes=EC2):
    """
    @param ecDet            (ElementContainer)
    @param ecRes            (ElementContainer)
    @retval EC2           (ElementContainer)
    """
    return DC.NumpyFFTConvolution(ecDet,ecRes)

################################################################################################################

def NumpyFFT(ec0=EC):
    """
    @param ec0            (ElementContainer)
    @retval EC2           (ElementContainer)
    """
    return DC.NumpyFFT(ec0)

################################################################################################################

def NumpyIFFT(ec0=EC):
    """
    @param ec0            (ElementContainer)
    @retval EC2           (ElementContainer)
    """
    return DC.NumpyIFFT(ec0)

################################################################################################################

def OutputPartOfEC(ec=EC,initial=0.0,final=0.1):
    """
    @param  ec         (ElementContaienr)
    @param  initial    (double)
    @param  final      (double)
    @retval EC         (ElementContainer)
    """
    return DC.OutputPartOfEC(ec,initial,final)

################################################################################################################

# Dictionary for entry the name of functions
_functions = {
              "MemDeconvolution":MemDeconvolution,
              "LoadFinalData":LoadFinalData,
              "ReadECAndWriteText":ReadECAndWriteText,
              "EditInitLorentzParam":EditInitLorentzParam,
              "MemExecute":MemExecute,
              "LoadTextData":LoadTextData,
              "PrintFileNametype":PrintFileNametype,
              "GslFFTConvolution":GslFFTConvolution,
              "GslFFTDeconvolution":GslFFTDeconvolution,
              "NumpyFFTConvolution":NumpyFFTConvolution,
              "NumpyFFTDeconvolution":NumpyFFTDeconvolution,
              "NumpyFFT":NumpyFFT,
              "NumpyIFFT":NumpyIFFT,
              "OutputPartOfEC":OutputPartOfEC
              }
