#!/usr/bin/python
# -*- coding: utf-8 -*-

import os


def CheckForOutput( parent_dir ):
    """
    出力用パスをチェックする
    1. ~/ana/DNA/<parent_dir> ($UTSUSEMI_USR_PRIV_HOME/ana/DNA/<parent_dir>/)
    2. Current Path + <parent_dir>/
    
    @param parent_dir (str) "Absorb", "database", "Efficiency", "EOrg", "Mask", "setup" など
    @return full_path_dir : 最終的に使用するフォルダのパスを返す
    @retrun ""            : 見つからなかった場合
    """

    # Check ~/ana/DNA/<parent_dir>
    if "UTSUSEMI_INST_CODE" in os.environ:
        inst_code = os.environ["UTSUSEMI_INST_CODE"]
    elif "UTSUSEMI_SYS_NAME" in os.environ:
        inst_code = os.environ["UTSUSEMI_SYS_NAME"]
    else:
        inst_code = "DNA"

    if "UTSUSEMI_USR_PRIV_HOME" in os.environ:
        user_dir = os.environ["UTSUSEMI_USR_PRIV_HOME"]
    elif "UTSUSEMI_USR_DIR" in os.environ:
        user_dir = os.environ["UTSUSEMI_USR_DIR"]

    full_path_dir = os.path.join( user_dir, "ana", inst_code, parent_dir )
    if os.path.isdir( full_path_dir ):
        if os.access( full_path_dir, os.W_OK ):
            return full_path_dir
        else:
            print("SearchPathDNA::CheckForOutput >> "+" cannot write / make new file in "+full_path_dir)

    # Check Current Path + <parent_dir>
    full_path_dir = os.path.join( os.getcwd(), parent_dir )
    if os.path.isdir( full_path_dir ):
        if os.access( full_path_dir, os.W_OK ):
            return full_path_dir
        else:
            print("SearchPathDNA::CheckForOutput >> "+" cannot write / make new file in "+full_path_dir)
    else:
        try:
            os.makedirs( full_path_dir )
        except:
            print("SearchPathDNA::CheckForOutput >> "+" cannot make new directry as "+full_path_dir)
            return ""

    return full_path_dir

def CheckForInput( parent_dir, file_name ):
    """
    入力用パスとファイルをチェックする
    1. ~/ana/DNA/<parent_dir>/<file_name> ($UTSUSEMI_USR_PRIV_HOME/ana/DNA/<parent_dir>/<file_name>)
    2. Current Path + <parent_dir>/<file_name>
    
    @param parent_dir (str) "Absorb", "database", "Efficiency", "EOrg", "Mask", "setup" など
    @param file_name (str)
    @return "" : ファイルが見つからない
    @return /full/path/to/file : ファイルが見つかった
    """
    # Check ~/ana/DNA/
    if "UTSUSEMI_INST_CODE" in os.environ:
        inst_code = os.environ["UTSUSEMI_INST_CODE"]
    elif "UTSUSEMI_SYS_NAME" in os.environ:
        inst_code = os.environ["UTSUSEMI_SYS_NAME"]
    else:
        inst_code = "DNA"

    if "UTSUSEMI_USR_PRIV_HOME" in os.environ:
        user_dir = os.environ["UTSUSEMI_USR_PRIV_HOME"]
    elif "UTSUSEMI_USR_DIR" in os.environ:
        user_dir = os.environ["UTSUSEMI_USR_DIR"]

    full_path_dir = os.path.join( user_dir, "ana", inst_code, parent_dir )
    if os.path.isdir( full_path_dir ):
        full_path_file = os.path.join( full_path_dir, file_name )
        if os.path.exists( full_path_file ):
            return full_path_file

    # Check CurrentPath/<parent_dir>/<file_name>
    full_path_dir = os.path.join( os.getcwd(), parent_dir )
    if os.path.isdir( full_path_dir ):
        full_path_file = os.path.join( full_path_dir, file_name )
        if os.path.exists( full_path_file ):
            return full_path_file

    return ""

if __name__ == '__main__':
    targets = ["Absorb", "database", "Efficiency", "EOrg", "Mask", "setup"]
    for a_folder in targets:
        ret=CheckForOutput( a_folder )
        if ret=="":
            print( "Failed to CheckForOutput return value=%s."%(a_folder))
        else:
            print( "Succeeded to CheckForOutput to %s"%(ret))

    for a_folder in targets:
        ret = CheckForInput( a_folder, "test.txt" )
        if ret=="":
            print( "Failed to CheckForIntput in %s."%(a_folder))
        else:
            print( "Succeeded to CheckForInput to %s"%(ret))
