#! /usr/bin/env python
# -*- coding:utf-8 -*-
import tkinter as Tkinter
import datetime
import time
import os
import shutil
import Manyo as mm
import Manyo.Utsusemi as mu
import Cmm
import uGao.MPlot as MP
import uGao.M2PlotPlusCui as MP2
import ElasticScanGUIBase as ESB
import T0fileMake as T0M
import subprocess

import ElasticScanPy3 as ESP3

class App(Tkinter.Frame):
    def __init__(self, master = None, ):
        Tkinter.Frame.__init__(self, master,bg="#00FFFF")
        self.master.title("DNA Elastic Scan Reduction Check")
        self.errorstr = Tkinter.StringVar()
        self.errorstr.set("Elastic Scan Stand-by.")

        display = Tkinter.Label(self, textvariable = self.errorstr, font = ('Helvetica', '16', 'bold'))
        display.pack( side = Tkinter.TOP)

        f1 = Tkinter.LabelFrame(self)
# Set Run No.
        f10 = Tkinter.LabelFrame( f1, relief = Tkinter.FLAT)
        rd = Tkinter.Label(f10, text = " Run No.")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.run = Tkinter.Spinbox( f10, from_=1000, to=50000, increment=1, width=5)
        self.run.delete( 0, Tkinter.END)
        self.run.insert( 0, '10371')
        self.run.pack(pady=2,side = Tkinter.LEFT)
        rd = Tkinter.Label( f10, text = "  Temp. Sensor")
        rd.pack(pady=0, side = Tkinter.LEFT)
        # Read Temperature
        ChList = ("A","B","C","C2","D","D2","D3","D4","D5")
        self.Ch = Tkinter.StringVar()
        self.Ch.set(ChList[0])
        self.ChMenu = Tkinter.OptionMenu( f10, self.Ch, *ChList)
        self.ChMenu.pack(pady=0, side = Tkinter.LEFT)

        button2 = Tkinter.Button( f10, text = "Read Temp.", command = self.readtemp)
        button2.pack(pady=0, side = Tkinter.LEFT)
        f10.pack(padx=5, pady=0, fill = Tkinter.BOTH)
        #####################
        #Set Time Parameter
        f11 = Tkinter.LabelFrame( f1, relief = Tkinter.FLAT)
        rd = Tkinter.Label(f11, text = "Time")
        rd.pack(pady=0, side = Tkinter.TOP, anchor = Tkinter.W)
        rd = Tkinter.Label( f11, text = "Start:")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.Sta = Tkinter.Spinbox( f11, from_=0, to=9999999, increment=1, width=7, format='%7.0f')
        self.Sta.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f11, text = "sec.  End:")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.End = Tkinter.Spinbox( f11,from_=0,to=9999999,increment=1,width=7,format='%7.0f')
        self.End.delete( 0, Tkinter.END)
        self.End.insert( 0, '180')
        self.End.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f11, text = "sec.  Time Bin:")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.Bin = Tkinter.Spinbox( f11,from_=1,to=999,increment=1,width=3,format='%3.0f')
        self.Bin.delete( 0, Tkinter.END)
        self.Bin.insert( 0, '60')
        self.Bin.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f11, text = "sec.")
        rd.pack(pady=0, side = Tkinter.LEFT)
        f11.pack(padx=5, pady=2, fill = Tkinter.BOTH)
        ###########
        #Set Tempaerature Parameter
        f12 = Tkinter.LabelFrame( f1, relief = Tkinter.FLAT)
        rd = Tkinter.Label(f12, text = "Temperature")
        rd.pack(pady=0, side = Tkinter.TOP, anchor = Tkinter.W)
        rd = Tkinter.Label( f12, text = "Start:")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.Ti = Tkinter.Spinbox( f12, from_=0, to=9999999, increment=1, width=7, format='%4.0f')
        self.Ti.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f12, text = "K  End:")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.Tf = Tkinter.Spinbox( f12,from_=0,to=9999999,increment=1,width=7,format='%4.0f')
        self.Tf.delete( 0, Tkinter.END)
        self.Tf.insert( 0, '300')
        self.Tf.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f12, text = "K  Bin:")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.TBin = Tkinter.Spinbox( f12,from_=1,to=999,increment=0.05,width=3,format='%2.1f')
        self.TBin.delete( 0, Tkinter.END)
        self.TBin.insert( 0, '1')
        self.TBin.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f12, text = "K")
        rd.pack(pady=0, side = Tkinter.LEFT)
        f12.pack(padx=5, pady=2, fill = Tkinter.BOTH)
        
        self.vReduction = Tkinter.IntVar()
        f13 = Tkinter.LabelFrame( f1, relief = Tkinter.FLAT)
        rd = Tkinter.Label(f13, text = "Reduction from event data ")
        rd.pack(pady=0, side = Tkinter.TOP, anchor = Tkinter.W)
        rd = Tkinter.Radiobutton(f13, text = 'Not Finished', value = 0, variable = self.vReduction)
        #rd = Tkinter.Radiobutton(f13, text = 'Not Finished', value = 0, variable = self.vReduction, command = self.sel_vReduction)
        rd.pack(padx=2, pady=2, side = Tkinter.LEFT)
        rd = Tkinter.Radiobutton(f13, text = 'Finished', value = 1, variable = self.vReduction)
        #rd = Tkinter.Radiobutton(f13, text = 'Finished', value = 1, variable = self.vReduction, command = self.sel_vReduction)
        rd.pack(padx=2, pady=2, side = Tkinter.LEFT)
        f13.pack(padx=5, pady=2, fill = Tkinter.BOTH)
  
        f1.pack(padx=5, pady=5, fill = Tkinter.BOTH)

        f2 = Tkinter.LabelFrame(self)

# Si(111) self.si < 4, Si(333) self.si > 3
# Si111 Select
        self.si = 0
        self.v111 = Tkinter.IntVar()
        self.v333 = Tkinter.IntVar()

        f21 = Tkinter.LabelFrame( f2, relief = Tkinter.FLAT)
        rd = Tkinter.Label(f21, text = "Si(111) : dQ=")
        rd.pack(padx=0,pady=0, side = Tkinter.LEFT)
        self.dqs1 = Tkinter.Spinbox( f21, from_=0.01, to=9.99, increment=0.01, width=4, format='%4.2f')
        self.dqs1.delete( 0, Tkinter.END)
        self.dqs1.insert( 0, '0.05')
        self.dqs1.pack(padx=0,pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label(f21, text = " Qmin=0.0 Qmax=2.0")
        rd.pack(padx=0,pady=0, side = Tkinter.LEFT)
        f21.pack(padx=0,pady=2, fill = Tkinter.BOTH)
        f22 = Tkinter.LabelFrame(f2, relief = Tkinter.FLAT)
        self.v111.set(2)
        rd = Tkinter.Radiobutton(f22, text = 'Fast Chopper OFF (Emin=-200,Emax=50,dE=50μeV) ', value = 0, variable = self.v111, command = self.sel_si111)
        rd.pack(padx=2, pady=2)
        rd = Tkinter.Radiobutton(f22, text = 'Fast Chopper ON  (1cm,1cm,225Hz,Ereso=2.5μeV) ', value = 1, variable = self.v111, command = self.sel_si111)
        rd.pack(padx=2, pady=2)
        rd = Tkinter.Radiobutton(f22, text = 'Fast Chopper ON  (3cm,3cm,225Hz,Ereso=3.5μeV) ', value = 2, variable = self.v111, command = self.sel_si111)
        rd.pack(padx=2, pady=2)
        rd = Tkinter.Radiobutton(f22, text = 'Fast Chopper ON  (1cm,STOP,225Hz,Ereso=3.0μeV)', value = 3, variable = self.v111, command = self.sel_si111)
        rd.pack(padx=2, pady=2)
        rd = Tkinter.Radiobutton(f22, text = 'Fast Chopper ON  (3cm,3cm,300Hz,Ereso=3.1μeV)', value = 4, variable = self.v111, command = self.sel_si111)
        rd.pack(padx=2, pady=2)
        rd.pack(padx=2, pady=2)
        rd = Tkinter.Radiobutton(f22, text = 'Fast Chopper ON  (1cm,1cm,300Hz,Ereso=2.4μeV)', value = 5, variable = self.v111, command = self.sel_si111)
        rd.pack(padx=2, pady=2)
        f22.pack(padx=0,pady=2, fill = Tkinter.BOTH)

        f23 = Tkinter.LabelFrame( f2, relief = Tkinter.FLAT)
        rd = Tkinter.Label( f23, text="  Emin=")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.emin = Tkinter.Spinbox( f23, from_=-999, to=999, increment=1, width=4, format='%4.0f')
        self.emin.delete( 0, Tkinter.END)
        self.emin.insert( 0, '-4')
        self.emin.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f23, text=",Emax=")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.emax = Tkinter.Spinbox( f23, from_=0, to=999, increment=1, width=4, format='%3.0f')
        self.emax.delete( 0, Tkinter.END)
        self.emax.insert( 0, ' 4')
        self.emax.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f23, text=",dE=")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.de = Tkinter.Spinbox( f23, from_=0.01, to=99, increment=0.01, width=5, format='%5.2f')
        self.de.delete( 0, Tkinter.END)
        self.de.insert( 0, ' 2')
        self.de.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f23, text="μeV")
        rd.pack(pady=0, side = Tkinter.LEFT)
        f23.pack(padx=5, pady=2, fill = Tkinter.BOTH)
	
        #[20220403] T0shift Add. by TY 
        f24 = Tkinter.LabelFrame( f2, relief = Tkinter.FLAT)
        rd = Tkinter.Label( f24, text="  T0Shift=")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.T0shift = Tkinter.Spinbox( f24, from_=0, to=400000, increment=1, width=6, format='%4.0f')
        self.T0shift.delete( 0, Tkinter.END)
        self.T0shift.insert( 0, '12325')
        self.T0shift.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f24, text="μs")
        rd.pack(pady=0, side = Tkinter.LEFT)
        f24.pack(padx=5, pady=2, fill = Tkinter.BOTH)


        f2.pack(padx=5, pady=2, fill = Tkinter.BOTH)


#Si 333 GUI
        f3 = Tkinter.LabelFrame(self)
        f31 = Tkinter.LabelFrame(f3, relief = Tkinter.FLAT)
        rd = Tkinter.Label(f31, text = "Si(333) : dQ=")
        rd.pack(padx=0,pady=0, side = Tkinter.LEFT)
        self.dqs3 = Tkinter.Spinbox( f31, from_=0.01, to=9.99, increment=0.01, width=4, format='%4.2f')
        self.dqs3.delete( 0, Tkinter.END)
        self.dqs3.insert( 0, '0.15')
        self.dqs3.pack(padx=0,pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f31, text = " Qmin=0.0 Qmax=6.0")
        rd.pack(padx=0,pady=0, side = Tkinter.LEFT)
        f31.pack(padx=0,pady=2, fill = Tkinter.BOTH)

        f32 = Tkinter.LabelFrame(f3, relief = Tkinter.FLAT)
        self.v333.set(0)
        rd = Tkinter.Radiobutton(f32, text = 'Fast Chopper OFF (Emin=-500,Emax=100,dE=50μeV)', value = 4, variable = self.v333, command = self.sel_si333)
        rd.pack(padx=2, pady=2)
        rd = Tkinter.Radiobutton(f32, text = 'Fast Chopper ON  (1cm,1cm,225Hz)               ', value = 5, variable = self.v333, command = self.sel_si333)
        rd.pack(padx=2, pady=2)
        f32.pack(padx=0,pady=2, fill = Tkinter.BOTH)

        f33 = Tkinter.LabelFrame( f3, relief = Tkinter.FLAT)
        rd = Tkinter.Label( f33, text="  Emin=")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.emin3 = Tkinter.Spinbox( f33, from_=-999, to=999, increment=1, width=4, format='%4.0f')
        self.emin3.delete( 0, Tkinter.END)
        self.emin3.insert( 0, '-500')
        self.emin3.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f33, text=",Emax=")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.emax3 = Tkinter.Spinbox( f33, from_=0, to=999, increment=1, width=4, format='%3.0f')
        self.emax3.delete( 0, Tkinter.END)
        self.emax3.insert( 0, '100')
        self.emax3.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f33, text=",dE=")
        rd.pack(pady=0, side = Tkinter.LEFT)
        self.de3 = Tkinter.Spinbox( f33, from_=0.01, to=99, increment=0.01, width=5, format='%5.2f')
        self.de3.delete( 0, Tkinter.END)
        self.de3.insert( 0, ' 50')
        self.de3.pack(pady=0, side = Tkinter.LEFT)
        rd = Tkinter.Label( f33, text="μeV")
        rd.pack(pady=0, side = Tkinter.LEFT)
        f33.pack(padx=5, pady=2, fill = Tkinter.BOTH)

        f3.pack(padx=5, pady=5, fill = Tkinter.BOTH)

# Button 
        button1 = Tkinter.Button(self, text = "Reduction Start", command = self.launch)
        button3 = Tkinter.Button(self, text = "Quit", command = self.master.destroy)
        button1.pack(side = Tkinter.LEFT)
        button3.pack(side = Tkinter.RIGHT)
        self.pack()
# self.step == 10: launch stand-by
        self.step = 10

        self.FastChopperUse = True
        self.CommentHeader = "ElasticGUI ->>"

    def sel_si111(self):
        if self.step == 10:
            i = self.v111.get()
        if ( self.si != i):
            self.v333.set(0)
            self.si = i
            self.emin.delete( 0, Tkinter.END)
            self.emax.delete( 0, Tkinter.END)
            self.de.delete( 0, Tkinter.END)
        if ( i == 0):
            self.emin.delete( 0, Tkinter.END)
            self.emax.delete( 0, Tkinter.END)
            self.de.delete( 0, Tkinter.END)
            self.emin.insert( 0, '-200')
            self.emax.insert( 0, ' 50')
            self.de.insert( 0, ' 50')
            self.FastChopperUse = False
            self.T0shift.delete( 0, Tkinter.END)
            self.T0shift.insert( 0, '120')
        elif ( i == 1):
            self.emin.delete( 0, Tkinter.END)
            self.emax.delete( 0, Tkinter.END)
            self.de.delete( 0, Tkinter.END)
            self.emin.insert( 0, '-7')
            self.emax.insert( 0, ' 5')
            self.de.insert( 0, ' 3')
            self.FastChopperUse = True
            self.T0shift.delete( 0, Tkinter.END)
            self.T0shift.insert( 0, '12325')
        elif ( i == 2):
            self.emin.delete( 0, Tkinter.END)
            self.emax.delete( 0, Tkinter.END)
            self.de.delete( 0, Tkinter.END)
            self.emin.insert( 0, '-4')
            self.emax.insert( 0, ' 4')
            self.de.insert( 0, ' 2')
            self.FastChopperUse = True
            self.T0shift.delete( 0, Tkinter.END)
            self.T0shift.insert( 0, '12325')
        elif ( i == 4):
            self.emin.delete( 0, Tkinter.END)
            self.emax.delete( 0, Tkinter.END)
            self.de.delete( 0, Tkinter.END)
            self.emin.insert( 0, '-2')
            self.emax.insert( 0, ' 2')
            self.de.insert( 0, ' 2')
            self.FastChopperUse = True
            self.T0shift.delete( 0, Tkinter.END)
            self.T0shift.insert( 0, '12325')
        elif ( i == 5):
            self.emin.delete( 0, Tkinter.END)
            self.emax.delete( 0, Tkinter.END)
            self.de.delete( 0, Tkinter.END)
            self.emin.insert( 0, '-2')
            self.emax.insert( 0, ' 2')
            self.de.insert( 0, ' 2')
            self.FastChopperUse = True
            self.T0shift.delete( 0, Tkinter.END)
            self.T0shift.insert( 0, '12275')
        else:
            self.emin.delete( 0, Tkinter.END)
            self.emax.delete( 0, Tkinter.END)
            self.de.delete( 0, Tkinter.END)
            self.emin.insert( 0, '-10')
            self.emax.insert( 0, ' 10')
            self.de.insert( 0, ' 5')
            self.FastChopperUse = True
            self.T0shift.delete( 0, Tkinter.END)
            self.T0shift.insert( 0, '12325')

    def sel_si333(self):
        if self.step == 10:
            i = self.v333.get()
            if ( self.si != i):
                self.v111.set(-1)
                self.si = i
                self.emin3.delete( 0, Tkinter.END)
                self.emax3.delete( 0, Tkinter.END)
                self.de3.delete( 0, Tkinter.END)
                self.emax3.insert( 0, '100')
                self.de3.insert( 0, ' 50')
            if ( i == 4):
                self.emin3.insert( 0, '-500')
                self.FastChopperUse = False
            else:
                self.emin3.insert( 0, '-100')
                self.FastChopperUse = True

    def readtemp(self):
        if self.step == 10:
            runNo = int(self.run.get())
            TCh = self.Ch.get()
            print (self.CommentHeader, "RunNo: DNA%6d" %(runNo))
            print (self.CommentHeader, "Temperature Sensor: %s" %(TCh))
            print (self.CommentHeader, "Reading Temperature Start....")
            EC = Cmm.CheckSampleTempByRunNumber( runNo,TCh)
            print (self.CommentHeader, "Reading Temperature end")
            MP.MPlot(EC)
            self.errorstr.set("Temperature run# %d Ch %s" % (runNo, TCh))

    def launch(self):
        self.SetParams()
        self.StartElasticScan()

    def SetParams(self):
        self.RunNo = int(self.run.get())
        self.Tch = self.Ch.get()
        print (self.CommentHeader, "Run No.:", self.RunNo )
        print (self.CommentHeader, "Temperature Sensor: %s" %(self.Tch))
        self.StartTime = self.Sta.get()
        self.EndTime = self.End.get()
        self.TimeBin = self.Bin.get()
        print (self.CommentHeader, "StartTime: %s sec" %(self.StartTime))
        print (self.CommentHeader, "EndTime: %s sec" %(self.EndTime))
        print (self.CommentHeader, "TimeBin: %s sec" %(self.TimeBin))
        print (self.CommentHeader, "FastChopperUse:", self.FastChopperUse)
        self.StartTemp = self.Ti.get()
        self.EndTemp = self.Tf.get()
        self.TempBin = self.TBin.get()
        print (self.CommentHeader, "Start Temperature: %s K" %(self.StartTemp))
        print (self.CommentHeader, "End Temperature: %s K" %(self.EndTemp))
        print (self.CommentHeader, "Temperature BIn: %s K" %(self.TempBin))


        self.Analyzer = 111
        self.Emin = 0
        self.Emax = 0
        self.Ebin = 0
        self.Qmin = 0
        self.Qmax = 0
        self.Qbin = 0
        
        Mode = self.v111.get()
        Mode3 = self.v333.get()
        if Mode3 ==4 or Mode3 ==5:
            self.Analyzer = 333
        print (self.CommentHeader, "Analyzer:%d" %(self.Analyzer))
        
        if Mode <=5 and Mode>=0:
            self.Emin = self.emin.get()
            self.Emax = self.emax.get()
            self.Ebin = self.de.get()
            self.Qmax = 2.0
            self.Qbin = self.dqs1.get()
        elif Mode3 >=4:
            self.Emin = self.emin3.get()
            self.Emax = self.emax3.get() 
            self.Ebin = self.de3.get()
            self.Qmax = 6.0
            self.Qbin = self.dqs3.get()
        else:
            print (self.CommentHeader, "EBin Set Error")
            return -1
        
        self.Emin = float(self.Emin)/1000
        self.Emax = float(self.Emax)/1000
        self.Ebin = float(self.Ebin)/1000
        print (self.CommentHeader, "Emin:%.4f" %(self.Emin))
        print (self.CommentHeader, "Emax:%.4f" %(self.Emax))
        print (self.CommentHeader, "Ebin:%.6f" %(self.Ebin))
        print (self.CommentHeader, "Qmin:%2.1f" %(self.Qmin))
        print (self.CommentHeader, "Qmax:%2.1f" %(self.Qmax))
        print (self.CommentHeader, "Qbin:%s" %(self.Qbin))

    def showplot(self,dat):
        if type(dat) == type(mm.ElementContainer()):
            MP.MPlot(dat)
        elif type(dat) == type(mm.ElementCotainerArray()):
            MP2.M2Plot(dat)
        else:
            print (self.CommentHeader, "dat is not ElementContainer or ElementContainerArray")
            print (self.CommentHeader, "dat type is ", type(dat))

    def StartElasticScan(self):
        print (self.CommentHeader)
        print (self.CommentHeader, "ElasticScan Reduction Start")
        
        inifile = "ESGUIParams.ini"
        iniparams = ESB.SetESiniFile(inifile)
        
        iniparams.setparams("laticetype",self.Analyzer)
        if self.FastChopperUse:
            iniparams.setparams("UseFastChopper","True")
            if self.Analyzer == 111:
#                Mode = self.v111.get()
                iniparams.setparams("t0_offset",self.T0shift.get())
#                print (Mode)
#                if(Mode == 4):
#                    iniparams.setparams("t0_offset","12375")
#                elif(Mode == 5):
#                    iniparams.setparams("t0_offset","12275")
#                    #iniparams.setparams("t0_offset","12365")
#                else:
#                    iniparams.setparams("t0_offset","12325")
            elif self.Analyzer == 333:
                iniparams.setparams("t0_offset","4091")
        else:
            iniparams.setparams("UseFastChopper","False")
            iniparams.setparams("t0_offset",self.T0shift.get())
            #iniparams.setparams("t0_offset","120")
        
        iniparams.writeESinifiles()
        #---LambdaParam
        LambdaCenter = 6.321
        dLambda = 4.15 
        if self.Analyzer == 333:
            LambdaCenter = 3.4 
            dLambda = 4.16 
        
        LambdaParam = "%.4f,%.4f" %(LambdaCenter,dLambda)
        HWParam ="%.4f,%4f,%.6f" %(self.Ebin,self.Emin,self.Emax)
        HWParam2 ="%.4f,%4f" %(self.Emin,self.Emax)
        QParam = "%.2f,%.2f,%s" %(self.Qmin,self.Qmax,self.Qbin)
        print (self.CommentHeader, "HWParam: %s" %( HWParam))
        print (self.CommentHeader, "HWParam2: %s" %(HWParam2))
        print (self.CommentHeader, "LambdaParam: %s"  %(LambdaParam))
        print (self.CommentHeader, "Qparam: %s" %(QParam))
       
        TimeParam = "%s,%s,%s" %(self.StartTime,self.EndTime,self.TimeBin)
        TempParam = "%s,%s,%s" %(self.StartTemp,self.EndTemp,self.TempBin)
        print (self.CommentHeader, "TimeParam: %s" %(TimeParam))
        print (self.CommentHeader, "TempCh: %s" %(self.Tch))
        print (self.CommentHeader, "TempParam: %s" %(TempParam))

        #dataPath = "/home/dnaadmin/DNA/tmp/" #T.Yamada[130218]
        dataPath = os.path.join(mu.UtsusemiEnvGetUserDir(), "DNA", "tmp")  #[inamura 230301]
        ECMbstName = "ECM_%d_ES.bst" %(self.RunNo)
        
        FileHeader = "ESGUIRun"
        ESName = "%s%dES.txt" % (FileHeader, self.RunNo)
        ESTimeName = "%s%dEStime.txt" % (FileHeader, self.RunNo)
        TIName = "%s%dTI.txt" % (FileHeader, self.RunNo)
        TITimeName = "%s%dTItime.txt" % (FileHeader, self.RunNo)
        TempLogName = "%s%dTempLog.txt" %(FileHeader, self.RunNo)
    
        #copyresult, messg =CopyEventData(int(self.RunNo))
        #print (messg) 

        #print (type(self.RunNo), self.RunNo)
        T0M.MakeT0file(str("%06d" %int(self.RunNo)))

        import ElasticScan 
        #Make Case Info xml
        ESP3.MakeCaseInfoXML(float(self.StartTime), float(self.EndTime), float(self.TimeBin))
        print (self.CommentHeader, "ECM make start")
        ECM = ESP3.ESTimeSlice(RunNo=int(self.RunNo), dataFolder="/data", HWParam=HWParam, LambdaParam=LambdaParam, QParam=QParam, inifile=inifile)
        #ECM = ElasticScan.GetQETimeECMMulth(self.RunNo, HWParam, LambdaParam, QParam, TimeParam, inifile)
        print (self.CommentHeader, "ECM make end")
        
        #ECM = ElasticScan.ReadECM(ECMbstName)
        EC = ElasticScan.ElasticScanTotalIntensity(ECM, HWParam2, QParam, inifile)
        print (self.CommentHeader, "Total Intensity vs Time")
        ElasticScan.OutputECText(EC, TITimeName)
        ElasticScan.OutPutElasticScanECM(ECM)
        del ECM
        del ElasticScan
        self.showplot(EC)
        print ("Finished")
        return -1
        #----------------- 
        #u2 vs time is calculated
        ECA = ElasticScan.ElasticScanQ2LnI(ECM, HWParam2, QParam, inifile)
        EC1 = ElasticScan.ElasticScanFit(ECA, "p1")
        ElasticScan.OutputECText(EC1, ESTimeName)
        self.showplot(EC1)
        del ECM
        del ECA
        #Time is converted to temperature.
        EC2 = ElasticScan.ElasticScanCheckTempNew(EC, self.Tch)
        EC4 = ElasticScan.ElasticScanXAxisChangeToTemp(EC, EC2, TempParam)
        ElasticScan.OutputECText(EC2,TempLogName) #Temperature log
        ElasticScan.OutputECText(EC4, TIName) #TotalIntensity vs Temperature
        EC3 = ElasticScan.ElasticScanXAxisChangeToTemp(EC1, EC2, TempParam)
        ElasticScan.OutputECText(EC3, ESName) #u2 vs Temperature
        print (self.CommentHeader, "ElasticScan Reduction End")
        print (self.CommentHeader, "I(Q) vs time is saved as \n%sRun%sIQ.txt\n" %(dataPath,self.RunNo) )
        print (self.CommentHeader, "u2 is saved as \n%s%s\n%s%s\n" %(dataPath, ESName, dataPath, ESTimeName))
        print (self.CommentHeader, "Total intensity is saved as \n%s%s\n%s%s\n" %(dataPath, TIName, dataPath, TITimeName))
        print (self.CommentHeader, "Temperature Log is saved as \n%s%s\n" %(dataPath, TempLogName))
        
        self.showplot(EC3)

def CopyEventData(RunNo):
    command = "ssh dnaadmin@192.168.1.10 /home/dnaadmin/Yamada/01_CopyEventData/CopyEventEdata.sh %d" %(RunNo)
    args = command.split(" ")
    proc = subprocess.Popen(args, stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = subprocess.PIPE)
    stdout_data, stderr_data = proc.communicate()
    print ("stdout_data >>", stdout_data)
    print ("stderr_data >>", stderr_data.replace("\n",""))
    result = proc.returncode
    #proc.close()
    if result == 1:
        messg =  "DNA%06d_* is not found on /data and /ifs_data/DNA/DNA" %RunNo
    else:
        messg =  "DNA%06d_* is ready for the reduction." %RunNo
    return result, messg


if __name__ == "__main__":
    FastChopperUse = False
    app = App()
    app.mainloop()
