import threading
import time
import wx
import wx.lib.newevent
import sys
SHOW_PROGRESS        = True
(ExecStartEvent , EVT_EXEC_START ) = wx.lib.newevent.NewEvent()
(ExecEndEvent   , EVT_EXEC_END   ) = wx.lib.newevent.NewEvent()
(ProgressEvent  , EVT_PROGRESS   ) = wx.lib.newevent.NewEvent()
class ExecCommandCommon:
    def __init__(self,func,event=None,args=(),objs=[],onfunc=None,offfunc=None):
        self.func   = func
        self.event  = event
        self.objs   = objs
        self.onfunc = onfunc
        self.offfunc= offfunc

        if self.event!=None:
            self.obj=event.GetEventObject()
            self.obj.Bind(EVT_EXEC_START,self.execCommandStart)
            self.obj.Bind(EVT_EXEC_END,  self.execCommandEnd)
            if SHOW_PROGRESS:
                self.progress=None
                self.obj.Bind(EVT_PROGRESS,  self.progressCommand)
        else:
            self.obj=None

        for obj in self.objs:
            obj.Bind(EVT_EXEC_START,self.execCommandStart)
            obj.Bind(EVT_EXEC_END  ,self.execCommandEnd)

        if isinstance(args, tuple):
            self.args=args
            pass
        elif isinstance(args, tuple):
            self.args=args
            pass
        else:
            self.args=(args,)

        self.threadProcess   = threading.Thread(target=self.func, args=self.args)
        self.watchDogProcess = threading.Thread(target=self.watchDog)
        self.execCommand()
#-----------------------------------------------------------------------------------
    def execCommand(self):
        if self.obj!=None:
            evt = ExecStartEvent()
            evt.SetEventObject(self.obj)
            wx.PostEvent(self.obj, evt)

        if len(self.objs)>0:
            for obj in self.objs:
                evt = ExecStartEvent()
                evt.SetEventObject(obj)
                wx.PostEvent(obj, evt)

        if self.onfunc!=None:
            self.onfunc()

        self.threadProcess.start()
        self.watchDogProcess.start()
#-----------------------------------------------------------------------------------
    def watchDog(self):

        count =0
        while 1:
            if self.threadProcess.isAlive():
                if self.obj!=None and SHOW_PROGRESS:
                    evt = ProgressEvent(count=count)
                    evt.SetEventObject(self.obj)
                    wx.PostEvent(self.obj, evt)
                time.sleep(1)
                count +=1
            else:
                break

        if self.obj!=None and SHOW_PROGRESS:
            evt = ProgressEvent(count=-1)
            evt.SetEventObject(self.obj)
            wx.PostEvent(self.obj, evt)
            time.sleep(1)

        if self.obj!=None:
            evt = ExecEndEvent()
            evt.SetEventObject(self.obj)
            wx.PostEvent(self.obj, evt)

        if len(self.objs)>0:
            for obj in self.objs:
                evt = ExecEndEvent()
                evt.SetEventObject(obj)
                wx.PostEvent(obj, evt)

        if self.offfunc!=None:
            self.offfunc()
#-----------------------------------------------------------------------------------
    def progressCommand(self,event):

        if event.count==0:
            self.progress = wx.ProgressDialog("Progress",
                                    "            Process is running now     ",
                                    maximum = 3600,
                                    #style = wx.PD_CAN_ABORT
                                     #| wx.PD_CAN_SKIP
                                    style = wx.PD_ELAPSED_TIME
                                     #| wx.PD_APP_MODAL
                                     #| wx.PD_ESTIMATED_TIME
                                     #| wx.PD_REMAINING_TIME
                                     )

        elif event.count==-1 and self.progress!=None:
            self.progress.Destroy()
            self.pregress=None

        elif self.progress!=None:
            val=event.count%3600
            self.progress.Update(val,"")

        else:
            pass
#-----------------------------------------------------------------------------------
    def execCommandStart(self,event):
        obj=event.GetEventObject()
        obj.Disable()
#-----------------------------------------------------------------------------------
    def execCommandEnd(self,event):
        obj=event.GetEventObject()
        obj.Enable()
