#include "UtsusemiEventDataConverterDNA.hh"
//////////////////////////////////////////////////////////
UtsusemiEventDataConverterDNA::
UtsusemiEventDataConverterDNA(){
    Initialize();
}

//////////////////////////////////////////////////////////
UtsusemiEventDataConverterDNA::
~UtsusemiEventDataConverterDNA(){
    delete stools;
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
Initialize(){
    _MessageTag = "UtsusemiEventDataConverterDNA >> ";
    stools = new StringTools();
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
LoadParamFiles( std::string w_file, std::string d_file, std::string c_file ){
    SetEventParams( w_file, d_file );
    if (c_file!="") SetCaseInfoParams( c_file );

}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
LoadChopCondFile(std::string w_file, std::string d_file,std::string cc_file){
    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
    FF->SetChopCondFile( w_file, d_file, cc_file );
    _EventDecoder->SetChopperParametersFromFiles(cc_file);
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetLambdaParam(Double lambdaCenter,Double deltaLambda){
    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
    FF->SetLambdaParam(lambdaCenter, deltaLambda);
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetTOFOffset(Double tofOffset){
    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTOFOffset(tofOffset);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetTOFResolver(Double tofResolver){
    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTOFResolver(tofResolver);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetTOFResolver(Double tofResolver1,Double tofResolver2){
    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTOFResolver(tofResolver1,tofResolver2);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetTimeParamAtSource(Double tofMinSource, Double tofMaxSource){
    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTimeParamAtSource(tofMinSource, tofMaxSource);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetT0Detector(){
    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTOFL2L3(_EventDecoder->_pixelT0Detector);
}
//////////////////////////////////////////////////////////
//void UtsusemiEventDataConverterDNA::
//SetInstrumentPosition(Double lchopper, Double lband, Double l1){
//    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
//    FF->SetInstrumentPosition(lchopper, lband, l1);
//}
//
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::SetTOFOffsetFile(std::string o_file)
    {
    std::vector<std::vector<Double> > xyValues;
    xyValues=ReadTOFOffsetFile(o_file);

    _EventDecoder->_pixelTOFOffsetFileVect.clear();
    for (UInt4 i=0;i<xyValues.size();i++)
        {
        for (UInt4 j=0;j<xyValues.at(i).size();j++)
            {
            _EventDecoder->_pixelTOFOffsetFileVect.push_back(xyValues.at(i).at(j));
            }
        }
    }
//////////////////////////////////////////////////////////
Int8 UtsusemiEventDataConverterDNA::_find(std::string line,std::vector<std::string> tag,Int4 pos)
    {
    UInt8 retpos=line.size();
    UInt8 tmppos=std::string::npos;
    for (UInt4 i=0;i<tag.size();i++)
        {
        tmppos=line.find(tag[i],pos);
        if (tmppos !=std::string::npos && tmppos<retpos)
            retpos=tmppos;
        }
    return retpos;
    }
//////////////////////////////////////////////////////////
std::vector<std::vector<Double> > UtsusemiEventDataConverterDNA::ReadTOFOffsetFile(std::string fileName)
    {
    std::ifstream offsetFile;
    std::stringstream ss;
    Double val;
    offsetFile.open(fileName.c_str());
    std::vector<std::string> vecTag;
    vecTag.push_back(" ");
    vecTag.push_back(",");
    UInt8 pos1,pos2;
    std::vector<std::vector<Double> > xyValues;

    if(!offsetFile)
        {
        std::cout <<" can't open "<< fileName<<std::endl;
        }
    else
        {
        std::string line;
        while(offsetFile && getline(offsetFile, line)) { //while A start
            std::vector<Double> xValues;
            if (line.find("#")==0 || line.size()==0)
                { }
            else
                {
                pos1=0;
                while (1)
                    {
                    //pos2 = line.find(tag,pos1);
                    pos2 = _find(line,vecTag,pos1);
                    if (pos2 == std::string::npos) pos2=line.size();
                    if (pos2-pos1!=0)
                        {
                        ss << line.substr(pos1,pos2-pos1);
                        val = 0.0;
                        ss >> val;
                        ss.clear();
                        ss.str("");
                        xValues.push_back(val);
                        }
                    if (pos2==line.size()) break;
                    else pos1=pos2+1;
                    }
                if (xValues.size()!=0)
                    xyValues.push_back(xValues);
                }
            }
        }
    return xyValues;
    }
//////////////////////////////////////////////////////////
std::vector<Double > UtsusemiEventDataConverterDNA::PutEf()
    {
    std::vector<Double > ef = _EventDecoder-> _pixelEfVect;
/*
    _pixelEfVect.push_back(Ef);
    _pixelL1Vect.push_back(L1);
    _pixelL2Vect.push_back(L2);
    _pixelL3Vect.push_back(L3);
    _pixelPolarAngleVect.push_back(polarAngle);
    _pixelAzimAngleVect.push_back(azimAngle);
    _pixelThetaDetectorVect.push_back(thetaDetector);
    _pixelDThetaDetectorVect.push_back(dtheta);
    _pixelDOmega.push_back(dOmega);
    _pixelTofMin.push_back(tofmin);
    _pixelTofMax.push_back(tofmax);
    _pixelNumOfFrame.push_back(numOfFrame);
    _pixelT0Detector.push_back(t0_detector);
*/

    return ef;
    }
//////////////////////////////////////////////////////////
std::vector<Double > UtsusemiEventDataConverterDNA::PutPolarAngle()
    {
    std::vector<Double > pa = _EventDecoder-> _pixelPolarAngleVect;

    return pa;
    }
//////////////////////////////////////////////////////////
std::vector<Double > UtsusemiEventDataConverterDNA::PutAzimuthAngle()
    {
    std::vector<Double > aa = _EventDecoder-> _pixelAzimAngleVect;

    return aa;
    }
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetElementContainerDNA( UInt4 outer_pixel_id, ElementContainer* ec, UInt4 caseId ){
    if (caseId<=0) return;

    Int4 tof_bin_type = _EventDecoder->PutTofBinType( outer_pixel_id );
    if (tof_bin_type<0){
    std::cout <<_MessageTag<<"There is no information of tof_bin_type.[DNA tof_bin_type<0]"<<std::endl;
    }else{
    SetElementContainer(outer_pixel_id, ec, caseId);
    ExecMaskForEC(outer_pixel_id,tof_bin_type,ec);
    }
}


void UtsusemiEventDataConverterDNA::
ExecMaskForEC(UInt4 outer_pixel_id, Int4 tof_bin_type, ElementContainer *ec)
    {
    std::vector< std::vector<Double> > MaskVect;
    UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
    // PSD(HW)=27,PSD(HW,User)=28,PSD(TOF)=2,MON(E)=21,MON(TOF)=2,
    if (tof_bin_type==27 || tof_bin_type==28 || tof_bin_type==2 || tof_bin_type==21)
        {
        // PSD(HW)=27, PSD(HW,User)=28 ------------------------------------------------------------
        if (tof_bin_type==27 || tof_bin_type==28)
            {
            Double Ef = _EventDecoder->_pixelEfVect[outer_pixel_id];
            std::vector<Double> EiVect = FF->GetEiRange();

            if (EiVect.size()>0)
                {
                for (UInt4 i=0;i<EiVect.size()/2;i++)
                    {
                    std::vector<Double> tmp;
                    tmp.push_back( EiVect[2*i] - Ef );
                    tmp.push_back( EiVect[2*i+1] - Ef );
                    MaskVect.push_back(tmp);
                    }
                }
            //reverse(MaskVect.begin(),MaskVect.end());
            }
        // PSD(TOF)=2 , MON(TOF)=2 ----------------------------------------------------------------
        if (tof_bin_type==2)
            {
            std::vector<Double> T0SampleVect = FF->GetTOFRange();
            if (T0SampleVect.size()>0)
                {
                for (UInt4 i=0;i<T0SampleVect.size()/2;i++)
                    {
                    std::vector<Double> tmp;
                    tmp.push_back( T0SampleVect[2*i] );
                    tmp.push_back( T0SampleVect[2*i+1] );
                    MaskVect.push_back(tmp);
                    }
                }
            }
        // MON(E)=21 ------------------------------------------------------------------------------
        if (tof_bin_type==21)
            {
            std::vector<Double> EiVect = FF->GetEiRange();

            if (EiVect.size()>0)
                {
                for (UInt4 i=0;i<EiVect.size()/2;i++)
                    {
                    std::vector<Double> tmp;
                    tmp.push_back( EiVect[2*i]);
                    tmp.push_back( EiVect[2*i+1]);
                    MaskVect.push_back(tmp);
                    }
                }
            //reverse(MaskVect.begin(),MaskVect.end());
            }

        std::vector<Double> MaskedRanges;
        if (MaskVect.size()!=0)
            {
            for (UInt4 i=0;i<MaskVect.size();i++)
                {
                MaskedRanges.push_back(MaskVect.at(i).at(0));
                MaskedRanges.push_back(MaskVect.at(i).at(1));
                }
            }
        ec->PutHeaderPointer()->Add("MaskedRanges",MaskedRanges);


        //----------------------------------------------------------------------------------------
        }


    }

//////////////////////////////////////////////////////////
Int4 UtsusemiEventDataConverterDNA::
LoadEventDataFiles( UInt4 runNumber, std::string pathToData, std::string pathToT0data ){
    std::vector<UInt4> tmp(1, runNumber);
    return LoadEventDataFiles( tmp, pathToData, pathToT0data );
}
//////////////////////////////////////////////////////////
Int4 UtsusemiEventDataConverterDNA::
LoadEventDataFiles( std::vector<UInt4> runNumbers, std::string pathToData, std::string pathToT0data ){

    SetT0Detector(); //20140714 Append

    if (runNumbers.empty()) return 0;
    if (runNumbers[0]<=0){
        _runNumbers.clear();
        _runNumbers.push_back(0);
        return 0;
    }

    std::vector< std::vector< std::vector< std::vector<Int4>* >* >* >* _PixelInfoStore = _EventDecoder->_wirInfo->PixelInfoStore;
    if (_PixelInfoStore==NULL){
        std::cout << _MessageTag+"ReadEventData >>> There is no information about pixels from WiringInfo.xml" << std::endl;
        return -2;
    }

    if (pathToData=="") pathToData="/data";
    SetDataPath( pathToData, pathToT0data, runNumbers, false, _PixelInfoStore );
    if (_isReady){
        for (UInt4 daq=0; daq<(_PixelInfoStore->size()); daq++){
            if (_PixelInfoStore->at(daq)!=NULL){
                for (UInt4 mod=0; mod<(_PixelInfoStore->at(daq)->size()); mod++){
                    if (_PixelInfoStore->at(daq)->at(mod)!=NULL){
                        std::cout << _MessageTag+"ReadEventData >> Load event data file for daq,mod=" << daq << "," << mod << std::endl;
                        ReadEventData( daq, mod );
                        if (!(_isReady)){
                            std::cout << _MessageTag+"ReadEventData >>> fails to read Event data (daq="<< daq << ", mod=" << mod << std::endl;
                        }
                    }
                }
            }
        }
        //ReadEventData();
        if (!(_isReady)){
            std::cout << _MessageTag+"LoadEventDataFiles >>> fails to read event data files "<< std::endl;
            return -1;
        }
    }
    return 0;
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId ){
    UInt4 outerPixelId = 0;
    Int4 tofBinType = -1;
    while(true){
    if (_EventDecoder->_wirInfo->TofBinInfoList[outerPixelId]!=NULL){
        std::vector<Double>* tofBinInfo = _EventDecoder->_wirInfo->TofBinInfoList[outerPixelId];

        UInt4 tof_pat_id = (UInt4)(tofBinInfo->at(0));
        if (_EventDecoder->_wirInfo->TofBinPtnInfo[ tof_pat_id ]!=NULL){
        tofBinType = _EventDecoder->_wirInfo->TofBinPtnInfo[ tof_pat_id ]->type;
        break;
        }
    }
    outerPixelId++;
    }

    if (tofBinType<0) return;

    _SetElementContainerMatrix(ecm, caseId );

    HeaderBase* hh = ecm->PutHeaderPointer();
    std::vector<std::string> process_h = hh->PutStringVector("DATAPROCESSED");
    //std::cout << "@@@@@@ TOF_BIN_TYPE=" << tofBinType << std::endl;
    if (tofBinType==20){
    process_h.push_back( "TOF TO ENERGY TRANSFER" );
    //std::vector< Double > EfixV( _EventDecoder->_tofBinConv->PutEfixVect() );
    //if (!(EfixV.empty())) {
    //    hh->Add( "Ei", EfixV[0] );
    //    for (UInt4 i=0;i<ecm->PutSize();i++) ecm->PutPointer(i)->PutHeaderPointer()->Add( "Ei", EfixV[0] );
    //}
    }else if (tofBinType==21){
    process_h.push_back( "TOF TO ENERGY" );
    }else if (tofBinType==22){
    process_h.push_back( "TOF TO Q" );
    }else{
    process_h.push_back( "EVENTS TO TOF" );
    }

    hh->OverWrite("DATAPROCESSED",process_h);

}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNumber, std::string pathToData, std::string pathToT0data, UInt4 caseId ){
    LoadEventDataFiles( runNumber, pathToData, pathToT0data );
    SetElementContainerMatrix( ecm, caseId );
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
_SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId ){

    std::vector< std::vector< std::vector< std::vector<Int4>* >* >* >* pixelInfoStore = _EventDecoder->_wirInfo->PixelInfoStore;

    HeaderBase* ecm_h = ecm->PutHeaderPointer();
    if (!AddRunInfoToHeader( ecm_h, caseId )){
        UtsusemiError("UtsusemiEventDataConverterDNA::_SetElementContainerMatrix >> failed to add RunInfo to Header.");
        return;
    }

    UInt4 outerPixelId=0;
    Int4 tofBinType = -1;
    while(true){
    if (_EventDecoder->_wirInfo->TofBinInfo[outerPixelId]!=NULL){
        std::vector<Double>* tofBinInfo = _EventDecoder->_wirInfo->TofBinInfoList[outerPixelId];

        UInt4 tof_pat_id = (UInt4)(tofBinInfo->at(0));
        if (_EventDecoder->_wirInfo->TofBinPtnInfo[ tof_pat_id ]!=NULL){
        tofBinType = _EventDecoder->_wirInfo->TofBinPtnInfo[ tof_pat_id ]->type;
        break;
        }
    }
    outerPixelId++;
    }

    if (tofBinType<0) return;

    std::vector<std::string> process_h;
    process_h.push_back( "E2H" );

    ecm_h->Add( "DATAPROCESSED", process_h );


    std::vector<Int4> table_ECA;
    UInt4 index_ECA = 0;
    for (UInt4 daqId=0; daqId<(pixelInfoStore->size()); daqId++){
    if (pixelInfoStore->at(daqId)==NULL) continue;
    for (UInt4 modNo=0; modNo<(pixelInfoStore->at(daqId)->size()); modNo++){
        if (pixelInfoStore->at(daqId)->at(modNo)==NULL) continue;
        for (UInt4 psdNo=0; psdNo<(pixelInfoStore->at(daqId)->at(modNo)->size()); psdNo++){
        UInt4 detId = pixelInfoStore->at(daqId)->at(modNo)->at(psdNo)->at(1);
        if (detId<0) continue;
        if (table_ECA.size()<=detId) table_ECA.resize( detId+1,-1 );
        table_ECA[detId]=index_ECA;
        index_ECA++;
        }
    }
    }
    clock_t t1,t2;
    t1=clock();

    ecm->Allocate(index_ECA);

    std::vector<Int4> bankIdList = _EventDecoder->_detInfo->PutBankIdList();
    std::vector<std::string> bankNameList = _EventDecoder->_detInfo->PutBankName();
    bool isSetBankInfo = true;
    if (bankIdList.empty()) isSetBankInfo = false;

    UInt4 num_of_det = (_EventDecoder->_wirInfo->MaxDetId)+1;
    std::vector<Int4> hashTableOfBankId( num_of_det, -1 );
    std::vector<Int4> hashTableOfIndexInBank( num_of_det, -1 );
    std::vector<Int4> bankSizeList( bankIdList.size(), 0 );
    if (isSetBankInfo){
    ecm_h->Add( "BANKIDLIST", bankIdList );
    ecm_h->Add( "BANKNAMELIST", bankNameList );

    for (UInt4 i=0; i<bankIdList.size(); i++){
        std::vector<Int4> tmp = _EventDecoder->_detInfo->PutDetIdInBank( bankIdList[i] );
        if (tmp.empty()){
        }else{
        bankSizeList[i]=(Int4)(tmp.size());
        for (UInt4 j=0; j<tmp.size(); j++){
            if (tmp[j]<0){
            }else{
            if (tmp[j]<num_of_det) {
                hashTableOfBankId[(UInt4)(tmp[j])]=bankIdList[i];
                hashTableOfIndexInBank[(UInt4)(tmp[j])]=j;
            }
            }
        }
        }
    }
    ecm_h->Add( "BANKSIZELIST", bankSizeList );
    }


#ifdef MULTH
    //omp_set_num_threads( MULTH );
    omp_set_num_threads( _NumOfMulTh );
#endif

    for (UInt4 daqId=0; daqId<(pixelInfoStore->size()); daqId++){
    if (pixelInfoStore->at(daqId)==NULL) continue;
    for (UInt4 modNo=0; modNo<(pixelInfoStore->at(daqId)->size()); modNo++){
        if (pixelInfoStore->at(daqId)->at(modNo)==NULL) continue;
        for (UInt4 psdNo=0; psdNo<(pixelInfoStore->at(daqId)->at(modNo)->size()); psdNo++){
        UInt4 detId = pixelInfoStore->at(daqId)->at(modNo)->at(psdNo)->at(1);
        if (detId<0) continue;
        Int4 head_pixelId = pixelInfoStore->at(daqId)->at(modNo)->at(psdNo)->at(2);
        Int4 num_pixels = pixelInfoStore->at(daqId)->at(modNo)->at(psdNo)->at(3);

        ElementContainerArray* ECA = new ElementContainerArray();
        HeaderBase* h_ECA = ECA->PutHeaderPointer();
        h_ECA->Add( std::string("MASKED"), 0 );
        h_ECA->Add( std::string("TYPE"), std::string("PSD") );
        h_ECA->Add( std::string("PSDID"), Int4(detId) );
        h_ECA->Add( std::string("DETID"), Int4(detId) );
        if (isSetBankInfo) {
            h_ECA->Add( std::string("BANKID"), hashTableOfBankId[detId] );
            h_ECA->Add( std::string("INDEXINBANK"), hashTableOfIndexInBank[detId] );
        }
        std::vector<Int4> maskedEC;
        maskedEC.push_back(-1);
        h_ECA->Add( std::string("MASKEDElementContainer"), maskedEC );

        ECA->Allocate( (UInt4)num_pixels );
        /* UtsusemiEventDataConverterNeunet uses below but no need for DNA reductions
        std::vector< std::vector<Double>* >* detPositionInfoVect = _EventDecoder->_detInfo->detPositionInfoVect;
        if (detPositionInfoVect!=NULL)
            if (detId<detPositionInfoVect->size())
                if (detPositionInfoVect->at(detId)!=NULL)
                    h_ECA->Add( std::string(UTSUSEMI_KEY_HEAD_DETPOSINFO), *(detPositionInfoVect->at(detId)) );
        */

#pragma omp parallel for
        for (UInt4 pixel=0; pixel<(UInt4)num_pixels; pixel++){
            UInt4 pixelId = head_pixelId + pixel;
            ElementContainer* EC = new ElementContainer();
            HeaderBase* h_EC = EC->PutHeaderPointer();
            h_EC->Add(std::string("PSDID"), Int4(detId) );
            h_EC->Add(std::string("DETID"), Int4(detId) );
            h_EC->Add(std::string("MASKED"), 0 );
            h_EC->Add(std::string("PIXELID"), Int4(pixelId) );

            std::string label = "Run"+stools->Int4ToString(_runNumber)+"("+stools->Int4ToString(detId)+","+stools->Int4ToString(pixel)+")";
            h_EC->Add(std::string("Label"), label );

            std::vector<Double> ppv(3,0.0);
            ppv[0] = _EventDecoder->_pixelPositionVect[ pixelId ]->at(0);
            ppv[1] = _EventDecoder->_pixelPositionVect[ pixelId ]->at(1);
            ppv[2] = _EventDecoder->_pixelPositionVect[ pixelId ]->at(2);
            h_EC->Add(std::string("PixelPosition"),ppv);
            //h_EC->Add(std::string("PixelSolidAngle"), _EventDecoder->_pixelSolidAngleVect[ pixelId ] );
            //comment out 20140917 For DNA ,"PixelSolidAngle"
           // Add For DNA -- start
           if (tofBinType==27 || tofBinType==28)
              {
              h_EC->Add(std::string("Ef"), _EventDecoder->_pixelEfVect[ pixelId ] );
              h_EC->Add(std::string("L1"), _EventDecoder->_pixelL1Vect[ pixelId ] );
              h_EC->Add(std::string("L2"), _EventDecoder->_pixelL2Vect[ pixelId ] );
              h_EC->Add(std::string("L3"), _EventDecoder->_pixelL3Vect[ pixelId ] );
              h_EC->Add(std::string("PolarAngle"), _EventDecoder->_pixelPolarAngleVect[ pixelId ] );
              h_EC->Add(std::string("AzimAngle"), _EventDecoder->_pixelAzimAngleVect[ pixelId ]);
              h_EC->Add(std::string("thetaDetector"), _EventDecoder->_pixelThetaDetectorVect[ pixelId ] );
              h_EC->Add(std::string("dthetaDetector"), _EventDecoder->_pixelDThetaDetectorVect[ pixelId ] );
              h_EC->Add(std::string("SolidAngle"), _EventDecoder->_pixelDOmega[ pixelId ] );
              }
            // For DNA --end
            SetElementContainerDNA( pixelId, EC, caseId );

            EC->AddToHeader(std::string("TotalCounts"), EC->Sum() );

            ECA->Set( pixel, EC );

        }
        ecm->Set( table_ECA[detId], ECA );
        }
    }

    }
    t2 = clock();
    std::cout << _MessageTag <<">> Cost of time="<< (t2-t1) << std::endl;
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
MakeCaseTable(UInt4 runno, std::string pathToData, std::string pathToT0data, std::string trigModKey)
{
    SetDataPath( pathToData, pathToT0data, runno );
    if (_isReady){
        std::vector< std::vector<Int4>* >* caseInfoStore = _EventDecoder->_wirInfo->TrigInfoStore;
        if (caseInfoStore!=NULL){
            for (UInt4 i=0; i<caseInfoStore->size(); i++){
                if (caseInfoStore->at(i)!=NULL){
                    Int4 type = caseInfoStore->at(i)->at(0);
                    Int4 daq = caseInfoStore->at(i)->at(1);
                    Int4 mod = caseInfoStore->at(i)->at(2);

                    char key_c[30];
                    std::snprintf( key_c, sizeof(key_c), "%02d_%03d", daq, mod ); //[TY 20141205]
                    //std::sprintf( key_c, "%3s%06d_%02d_%03d", _instCode.c_str(), _runNumber, daq, mod );
                    std::string key( key_c );
                    std::vector<std::string> dfiles = _dataFileList.Put( key );
                    std::vector<std::string> tfiles = _t0dataFileList.Put( key );
                    /*
                    std::cout << "@@@ LoadTrignetEventFile i=" << i << std::endl;
                    std::cout << "@@@ data files = ";
                    for (UInt4 j=0;j<dfiles.size();j++) std::cout << dfiles[j]+",";
                    std::cout << std::endl;
                    std::cout << "@@@ t0data files = ";
                    for (UInt4 j=0;j<tfiles.size();j++) std::cout << tfiles[j]+",";
                    std::cout << std::endl;
                    */
                    ReadCaseEvent( i, dfiles, tfiles );
                }
            }
        }else{
            UtsusemiWarning( _MessageTag+"LoadTrigEventFiles >>> caseInfoStore is NULL " );
            std::vector<std::string> dfiles, tfiles;
            if ((trigModKey!="")&&(_dataFileList.Check( trigModKey )==1)){
                dfiles = _dataFileList.Put( trigModKey );
                tfiles = _t0dataFileList.Put( trigModKey );
            }else{
                dfiles = _dataFileList.Put(0);
                tfiles = _t0dataFileList.Put(0);
            }
            ReadCaseEvent( 0, dfiles, tfiles );
        }
        if (!(_isReady)){
            std::cout << _MessageTag+"LoadTrigEventFiles >>> fails to read event data files "<< std::endl;
            return;
        }
    }
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
LoadTrignetEventFile( UInt4 runno, std::string pathToData, std::string pathToT0data ){
    MakeCaseTable( runno, pathToData, pathToT0data );
}

//DNA TRIG TEST 2014/04
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
LoadTrignetChopFile( UInt4 runno, std::string pathToData, std::string pathToT0data ){
    SetDataPath( pathToData, pathToT0data, runno );
    std::cout <<"TY--LoadTrignetChopFile> pathToData:" << pathToData <<", pathToT0Data:" << pathToT0data << ", runno:" << runno <<std::endl;
    if (_isReady){
    std::vector< std::vector<Int4>* >* caseInfoStore = _EventDecoder->_wirInfo->TrigInfoStore;
    if (caseInfoStore!=NULL){
        for (UInt4 i=0; i<caseInfoStore->size(); i++){
        if (caseInfoStore->at(i)!=NULL){
            Int4 type = caseInfoStore->at(i)->at(0);
            Int4 daq = caseInfoStore->at(i)->at(1);
            Int4 mod = caseInfoStore->at(i)->at(2);

            char key_c[30];

            std::snprintf( key_c, sizeof(key_c), "%02d_%03d", daq, mod ); //[TY 20141205]
            //std::sprintf( key_c, "%3s%06d_%02d_%03d", _instCode.c_str(), _runNumber, daq, mod );
            std::string key( key_c );

            std::cout << "TY--> key=" << key << std::endl;
            //std::vector<std::string> dfiles = _dataFileList.Put( key );

            std::vector<std::string> dfiles = _dataFileList.Put( "03_128" );
            std::cout << "TY00--> key=" << key << std::endl;
            std::vector<std::string> tfiles = _t0dataFileList.Put( key );

            std::cout << "TY--> key=" << key << std::endl;
            std::cout << "@@@ LoadTrignetEventFile i=" << i << std::endl;
            std::cout << "@@@ data files = ";
            for (UInt4 j=0;j<dfiles.size();j++) std::cout << dfiles[j]+",";
            std::cout << std::endl;
            std::cout << "@@@ t0data files = ";
            for (UInt4 j=0;j<tfiles.size();j++) std::cout << tfiles[j]+",";
            std::cout << std::endl;
            //For DNA using ***
            UtsusemiFilterTrignetDNA *FF = _CaseDecoder->PutFilter();
            FF->LoadTrignetChopEventFile( i, dfiles, tfiles );

            //ReadCaseEvent( i, dfiles, tfiles );

            // AS DEBUG
            /*
            for (UInt4 i=0;i<FF->filterCaseTable->size();i++)
                {
                std::cout << "# "<<i << ":::";
                for (UInt4 j=0;j<FF->filterCaseTable->at(i)->size();j++)
                    {
                    std::cout << FF->filterCaseTable->at(i)->at(j) << ",";
                    }
                std::cout << std::endl;
                }
            std::cout << std::endl;
            */
        }
        }
    }else{
        std::cout << _MessageTag+"LoadTrignetChopFile >>> caseInfoStore is NULL "<< std::endl;
    }
    //ReadCaseEvent();
        if (!(_isReady)){
        std::cout << _MessageTag+"LoadTrignetChopFile >>> fails to read event data files "<< std::endl;
        return;
    }
    }else{
    std::cout << _MessageTag+"LoadTrignetChopFile >>> fails to SetDataPath "<< std::endl;
    }
}

//DNA TRIG TEST 2014/04


//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
ReadTrignetEventFile( std::string pathToTrigData, UInt4 index ){
    //std::vector<std::string> files(index+1,"");
    //files[index] = pathToTrigData;
    //ReadCaseEventFiles( files );
    std::vector<std::string> tmp1(1,pathToTrigData);
    std::vector<std::string> tmp2;
    tmp2.clear();
    ReadCaseEventFiles( index, tmp1, tmp2 );
}
//////////////////////////////////////////////////////////
std::vector<UInt4> UtsusemiEventDataConverterDNA::
DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size ){
    std::vector<UInt4> ret;
    ret.clear();

    if (_CaseDecoder->PutCaseTable()==NULL){
    std::cout << "@@@@ NULL" << std::endl;
    return ret;
    }
    if (isI1Size){
    ret.push_back( _CaseDecoder->PutCaseTable()->size() );
    }else if (isI2Size){
    if (i1<(_CaseDecoder->PutCaseTable()->size())){
        ret.push_back( (_CaseDecoder->PutCaseTable()->at(i1)->size())/2 );
    }
    }else if (i1<(_CaseDecoder->PutCaseTable()->size())){
    if (i2<((_CaseDecoder->PutCaseTable()->at(i1)->size())/2)){
        ret.push_back( _CaseDecoder->PutCaseTable()->at(i1)->at(i2*2) );
        ret.push_back( _CaseDecoder->PutCaseTable()->at(i1)->at(i2*2+1) );
    }
    }
    return ret;
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetRangeOfSingleTimeSlicing( double startSec, double endSec ){
    _CaseDecoder->SetRangeOfSingleTimeSlicing( startSec, endSec );
}
//////////////////////////////////////////////////////////
Int4 UtsusemiEventDataConverterDNA::
SetRangeOfSingleTimeSlicing( std::string startDate, std::string endDate ){
    return _CaseDecoder->SetRangeOfSingleTimeSlicing( startDate, endDate );
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNA::
SetElementContainerMatrixForPseudOnLineMon( ElementContainerMatrix* ecm, UInt4 caseId, UInt4 runNo ){
    _runNumber=runNo;
    _SetElementContainerMatrix( ecm, caseId );
}
//////////////////////////////////////////////////////////
Int4 UtsusemiEventDataConverterDNA::
SetDataPathTest( std::string dataPath, std::string t0Path, UInt4 runNo ){
    std::cout << "@@@ " << dataPath << "," << t0Path << "," << runNo << std::endl;
    SetDataPath( dataPath, t0Path, runNo );
    if (_isReady){
    return 0;
    }else{
    return -1;
    }
}
