#ifndef UTSUSEMIDNAILAMBDACORRECTIONUSEMONATSAMPLE
#define UTSUSEMIDNAILAMBDACORRECTIONUSEMONATSAMPLE

#include "UtsusemiHeader.hh"
#include "AdvDetectorManagerDNA.hh"
#include "AdvILambdaCorrectionDNA.hh"

//////////////////////////////////
// I Lambda Correction for DNA using monitor at sample position
// Y. Inamura : Oct 25th 2022 
/////////////////////////////////

//! 
/*! 
 * 
 * 
 *  
 * 
 */
class UtsusemiDNAILambdaCorrectionUseMonAtSample :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    std::string commentHead;
    Double _attenuateValue;
    void Initialize();
    StringTools *stools;
public:
    UtsusemiDNAILambdaCorrectionUseMonAtSample();
        //!< Constructor
        /*!<
         */
    UtsusemiDNAILambdaCorrectionUseMonAtSample(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    ~UtsusemiDNAILambdaCorrectionUseMonAtSample();
        //!< Destructor
        /*!<
         */

    bool PutILambda(ElementContainer& ec0, ElementContainer& ret, std::string filepath, bool isHighReso, double attenuateVal=1.0);
    bool ILCorrection(ElementContainerMatrix *ret, ElementContainerMatrix *ecm, ElementContainer& ec0, std::string filepath, bool isHighReso, double attenuateVal=0.0 );
        //!< executes I Lambda Correction
        /*!< 
         *   @return bool
         */
};

#endif
