#ifndef UTSUSEMICHOPCONDINFOREADERTRIGNET
#define UTSUSEMICHOPCONDINFOREADERTRIGNET
#include "UtsusemiCaseInfoReaderTrignet.hh"

#include "BoostXmlParser.hh"
class UtsusemiChopCondInfoReaderTrignet:
    public UtsusemiCaseInfoReaderTrignet{


private:
    StringTools *stools;
    std::string _CF_KEY;
    BoostXmlParser *_parserDetInfo;                  /**< XML parser  */
    BoostXmlParser *_parserWirInfo;                  /**< XML parser  */

public:
    UtsusemiChopCondInfoReaderTrignet();
        //!< Constructor
        /*!<
         */
    UtsusemiChopCondInfoReaderTrignet( std::string filename );
        //!< Constructor
        /*!<
         *   @param filename (std::string) path to CaseInfo.xml
         */
    ~UtsusemiChopCondInfoReaderTrignet();
        //!< Destructor
        /*!<
         */

    Double PutFastChopperFrequency();

    UInt4 PutNumOfFastChopperSlit();

    std::vector<Double> PutFastChopperSlitWidth();

    std::vector<Double> PutFastChopperSlitAngle();

    UInt4 PutFastChopperMode();

    Double PutL1();
    Double PutLChopper();
    Double PutLBandChopper();

    Double PutLambdaCenter();
    Double PutDeltaLambda();
    Double PutTOFoffset();

    Double PutTOFResolver1();
    Double PutTOFResolver2();

    Double PutTOFSourceMin();
    Double PutTOFSourceMax();

    Int4 PutTOFbintype();

    Int4 ImportDetectorInfo(std::string filepath);

    Int4 ImportWiringInfo(std::string filepath);


};
#endif
