#include "AdvModelParticle.hh"
#include "AdvModelDistribution.hh"


AdvModelParticle::AdvModelParticle(AdvModel* model)
{
        m_model = model;
}

AdvModelParticle::~AdvModelParticle()
{
}

void AdvModelParticle::deleteParams()
{
	vector<pair<string, AdvModelDistribution*> >::iterator it = particleParams.begin();

	while ( it != particleParams.end() )
	{
		AdvModelDistribution* p = (*it).second;
		if ( p != NULL ) delete p;
		++it;
	}

	particleParams.clear();
}

void AdvModelParticle::SetFuncParam(mxml_node_t* node)
{
	vector<pair<string, AdvModelDistribution*> >::iterator it;
        it = particleParams.begin();
        mxml_node_t *node1;
        while (it != particleParams.end()) {
            node1 = mxmlFindElement(node, node, (*it).first.c_str(), NULL, NULL, MXML_DESCEND);
            if (!node1){
              cout << "Values ["<<(*it).first<<"] is undefined" << endl;
            } else {
              (*it).second->SetAttr(node1);
            }
            ++it;
        }
}


void AdvModelParticle::MeanFormFactor( double q[3], Complex* retval )
{
	retval[1] = retval[0] = Complex(0.0, 0.0);
	return;
}

gsl_function AdvModelParticle::getMeanFormFactorFunc ()
{
	gsl_function f;
	f.function = NULL;
	f.params   = NULL;
	return f;
}

#include <utility>


AdvModelParticleSphere::AdvModelParticleSphere(AdvModel* model): AdvModelParticle(model)
{
	particleParams.clear();
	particleParams.resize(1);
	particleParams[0] = make_pair( string("R"), new AdvModelDistribution(m_model) );
}

AdvModelParticleSphere::~AdvModelParticleSphere()
{
	deleteParams();
}

void AdvModelParticleSphere::MeanFormFactor( double q[3], Complex* retval )
{
	
}

gsl_function AdvModelParticleSphere::getMeanFormFactorFunc ()
{
        gsl_function f;
        f.function = NULL;
        f.params   = NULL;
        return f;
}

double AdvModelParticleSphere::FF_Sphere_primitive ( double x )
{
	double d = sin(x) - x * cos(x) ;
	d = 3.0 * d / x / x / x ;
	return d * d ;
}

Complex AdvModelParticleSphere::MeanFormFactor_primitive( double q, double R )
{
	double p = FF_Sphere_primitive ( q * R ) ;
	return Complex(p, 0.0);
}

