#ifndef MODELDISTRIBUTION_HH
#define MODELDISTRIBUTION_HH

#include "AdvModel.hh"

#include <mxml.h>

class AdvModelParam;

class AdvModelDist
{
public:
    AdvModelDist(AdvModel* mdl);
    ~AdvModelDist();

    Double  ValueAt(Double);
    Double  ValueAtWeight(Double);

//    Double  GetR0();
//    Double  GetSigma();
//    Double  GetUpper();
//    Double  GetLower();

    void    SetAttr( mxml_node_t *node );
    void    GetAttr( mxml_node_t *node );

    pair<Double,Double>  GetDefaultRange (Double threshold);

private:
    AdvModel*     model;

    enum dist_func
    {
        NONE,
        GATE,
        LORENTZ,
        GAUSSIAN,
        COSINE,
        LOG_NORMAL,
        SCHULZ,
    };    

    dist_func    dtype;
    AdvModelParam*  value;
    AdvModelParam*  sigma;

    AdvModelParam*  upper;
    AdvModelParam*  lower;

    AdvModelParam*  weight;
};

class AdvModelDistribution
{
public:
    AdvModelDistribution(AdvModel* mdl);
    ~AdvModelDistribution();

    void    SetAttr( mxml_node_t *node );
    void    GetAttr( mxml_node_t *node );

    vector< pair<Double, Double> > GetWeight();

    void SetNDiv( Int4 n ) { ndiv = n; }

private:
    AdvModel*     model;

    Bool       bimodal;
    Int4       ndiv;

    AdvModelDist*  func1;     /** distribution function */
    AdvModelDist*  func2;     /** second distribution function (bimodal) */
};

#endif
