#include "AdvModel.hh"
#include "AdvModelParamSet.hh"

/**
  コンストラクタ
*/
AdvModel::AdvModel()
{
    m_paramset = new AdvModelParamSet;
}

/**
  デコンストラクタ
*/
AdvModel::~AdvModel()
{
    if (m_paramset)
    {
        m_paramset->DeleteAll();
        delete m_paramset;
    }
}

/**
  文字列比較（大文字小文字を区別しない）
  @param s1 文字列1
  @param s2 文字列2
  @return 文字列１と文字列２が同じなら 0 を返す
*/
int AdvModel::StrCmpI ( const char* s1, const char* s2)
{
    if (s1==NULL && s2==NULL) {return 0;}
    if (s1==NULL) { return 1; }
    if (s2==NULL) { return -1; }
    
    int c1, c2;
    int  i;
    for (i=0;;++i) {
      c1 = tolower(s1[i]);
      c2 = tolower(s2[i]);
      if (c1 != c2) { return c1>c2 ? 1 : -1; }
      if (c1 == '\0') { return 0; }
   }
   return 1;
}

