#!/usr/bin/python

import time
import optparse

import Manyo
#import MultiDataLevmar as Adv
import Adv

import OptionSelector
import PlotNorm
import PlotFittingResult

###############################################################################

############            command line option            ############
parser=optparse.OptionParser()
parser.add_option("-i", "--input", action="store", type="string", dest="inputFile", help="input file name", metavar="FILE")
options, args = parser.parse_args()
if not options.inputFile:
    parser.error("no input file specified.")

############            read source file            ############
io=Manyo.NeXusFileIO()
src = io.ReadElementContainerArray(options.inputFile)
print src.PutSize(), "element container(s) in the read array."

src.PutHeaderPointer().Dump()
for i in range(src.PutSize()):
    #src.PutPointer(i).PutHeader().dump()
    src.PutPointer(i).dump()

domainList=[]
for i in range(src.PutSize()):
    ec=src.Put(i)
    domain=Adv.Domain(ec, ec.Put(ec.PutXKey()).front(), ec.Put(ec.PutXKey()).back())
    print "i=", i, " domain: (", domain.getLowerBound(), ", ", domain.getUpperBound(), ")"
    domainList.append(domain)

method=Adv.MultiDataLevmar()
paramSet=method.setDefaultParam(src)
paramSet.dump()

paramSet.replace(Adv.MultiDataLevmar.CONSTRAIN,          Adv.MultiDataLevmar.NO_CONSTRAIN)
paramSet.replace(Adv.MultiDataLevmar.USE_NUMERICAL_DIFF, Adv.MultiDataLevmar.DEFAULT_USE_NUMERICAL_DIFF)
paramSet.replace(Adv.MultiDataLevmar.DIFF_METHOD,        Adv.MultiDataLevmar.DEFAULT_DIFF_METHOD)
paramSet.replace(Adv.MultiDataLevmar.USE_DATA_WEIGHTS,   Adv.MultiDataLevmar.DEFAULT_USE_DATA_WEIGHTS)
paramSet.replace(Adv.MultiDataLevmar.MAX_ITERATIONS,     Adv.MultiDataLevmar.DEFAULT_MAX_ITERATIONS)
paramSet.replace(Adv.MultiDataLevmar.OUTPUT_INTERVAL,    Adv.MultiDataLevmar.DEFAULT_OUTPUT_INTERVAL)

functions=[]
for i in range(src.PutSize()):
    #parser=Adv.FuncParser("g g g")
    #fl=parser.parse()
    functions.append("g g g")

paramSet.add(Adv.MultiDataLevmar.FUNCTIONS, functions);

fittingParams=Manyo.VrctorTool.MakeVectorDouble();
fittingParams.push_back( 60000.0)
fittingParams.push_back(     3.5)
fittingParams.push_back(     1.5)
fittingParams.push_back( 60000.0)
fittingParams.push_back(     6.0)
fittingParams.push_back(     3.0)
fittingParams.push_back( 50000.0)
fittingParams.push_back(    12.0)
fittingParams.push_back(     3.5)
fittingParams.push_back(     1.0)
paramSet.add(Adv.MultiDataLevmar.PARAMETERS_VALUES, fittingParams);

paramSet.dump()

print "check parameters: ", method.checkParam(src, domainList, paramSet)

method.toInnerForm(src. domainList, paramSet)
method.fit()

while method.ifFitting():
    sleep(1)

method.eval();
result=Manyo.ElementContainerArray()
method.toElementContainer(src, result)
result.PutHeader.Dump()
print result.PutSize(), "element container(s) in the result array."
for i in range(result.PutSize()):
    result.Put(i).PutHeader().Dump()

fittedParamSet = method.getFittedParam()
fittedParamSet.dump()

outputIO = Manyo.NeXusFilIO()
outputIO.Write(result, "fittedArray.data", "tanimori")
