#include "AdvMultiDataMethodFactory.hh"

const string className = string("MultiDataMethodFactroy");

/* initial value is  NULL */
AdvMultiDataMethodFactory *AdvMultiDataMethodFactory::instance=static_cast<AdvMultiDataMethodFactory*>(NULL);

/**
 *  default constructor
 */
AdvMultiDataMethodFactory::AdvMultiDataMethodFactory() {
}


/**
 *  return the singleton instance of the AdvMultiDataMethodFactory class
 */
AdvMultiDataMethodFactory * AdvMultiDataMethodFactory::getInstance() {
    if (AdvMultiDataMethodFactory::instance == static_cast<AdvMultiDataMethodFactory*>(NULL) ) {
        AdvMultiDataMethodFactory::instance = new AdvMultiDataMethodFactory();
    }
    return AdvMultiDataMethodFactory::instance;
}

/**
 *  create specified method
 */
AdvMultiDataMethod *AdvMultiDataMethodFactory::createMethod(const AdvMethodType &type) {

    AdvMultiDataMethod *method;

    switch (type.value) {
        case MULTIDATA_LEVMAR_ID:
            method = new AdvMultiDataLevmar();
            break;
        case CONVOLUTION_BY_FFT_ID:
            method = new AdvConvolutionByFFT();
            break;
        case DECONVOLUTION_BY_FFT_ID:
            method = new AdvDeconvolutionByFFT();
            break;
        case EQUAL_SPACING_ID:
            method = new AdvEqualSpacing();
            break;
        default:
            method = static_cast<AdvMultiDataMethod*>(NULL);
            break;
    }
    return method;
}

/**
 *  create specified method
 */
AdvMultiDataMethod *AdvMultiDataMethodFactory::createMethod(string methodName) {
    AdvMultiDataMethod *method;

    if (methodName == MULTIDATA_LEVMAR.name ) {
        method = new AdvMultiDataLevmar();
    } else if (methodName == CONVOLUTION_BY_FFT.name ) {
        method = new AdvConvolutionByFFT();
    } else if (methodName == DECONVOLUTION_BY_FFT.name ) {
        method = new AdvDeconvolutionByFFT();
    } else if (methodName == EQUAL_SPACING.name ) {
        method = new AdvEqualSpacing();
    } else {
        method=static_cast<AdvMultiDataMethod*>(NULL);
    }
    return method;
}
