#ifndef  METHOD_TYPE_H
#define  METHOD_TYPE_H 1

#include <string>

enum methodID {
    UNKNOWN_METHOD_ID,
    BSPLINE_ID,
    MOVING_AVERAGE_ID,
    LEVMAR_ID,
    NEW_LEVMAR_ID,
    MULTIDATA_LEVMAR_ID,
    CONVOLUTION_BY_FFT_ID,
    DECONVOLUTION_BY_FFT_ID,
    EQUAL_SPACING_ID,
};

struct _methodType {
    enum  methodID value;   /** type No.    */
    string name;            /** type name   */
    string symbol;          /** type symbol */
};

typedef struct _methodType AdvMethodType;

extern const AdvMethodType UNKNOWN_METHOD_TYPE;
extern const AdvMethodType BSPLINE;
extern const AdvMethodType MOVING_AVERAGE;
extern const AdvMethodType LEVMAR;
extern const AdvMethodType NEW_LEVMAR;
extern const AdvMethodType MULTIDATA_LEVMAR;
extern const AdvMethodType CONVOLUTION_BY_FFT;
extern const AdvMethodType DECONVOLUTION_BY_FFT;
extern const AdvMethodType EQUAL_SPACING;

#endif // METHOD_TYPE_H
