#ifndef DECONVOLUTIONBYFFT
#define DECONVOLUTIONBYFFT

#include "AdvVectorComplexTool.hh"
#include "AdvConvolutionBase.hh"
#include "AdvGslFFTComplex.hh"

class AdvDeconvolutionByFFT : virtual public AdvConvolutionBase, virtual public AdvVectorComplexTool {
    private:
        static const string className;

    protected:
        void setDefaultConvolutionType(AdvParamSet& paramSet); 
        Bool checkConvolutionType(AdvParamSet& paramSet) ;

    private:
        void addZeroSeqAtBack(vector<Double>& val, vector<Double>& err, UInt4 n) ;
        void eraseZeroSeqAtBack(vector<Double>& val, vector<Double>& err, const UInt4 n);
        void eraseZeroSeqAtBack(vector<Double>& val, vector<Double>& err);

    public:
        /** constructor */
        AdvDeconvolutionByFFT() : AdvConvolutionBase(string("AdvDeconvolutionByFFT")) {};
        /** destructor */
        ~AdvDeconvolutionByFFT() {};

        void eval();

        /////////////////////////////////////////////////////////////////////////////
        Double likehood() { return 0.0; };
        void fit() {};
        vector< vector<Double> > getTrend() { return *(new vector< vector<Double> >()); };
        vector< vector<Double> > getTrend(UInt4) { return *(new vector< vector<Double> >()); };
        void getParamDescription() const {};
        AdvParamSet getFittedParam() const { return *(new AdvParamSet()); };
        AdvParamSet* getLatestConvergenceStat() const { return new AdvParamSet(); };
};

#endif // DECONVOLUTIONBYFFT
