#include <iostream>
#include <istream>
#include <ostream>
#include <cstdlib>

#include "Header.hh"
#include "VectorArrayConv.hh"

vector<Double> initVector(Double xmin, Double xmax, Int4 ndiv) {

    vector<Double> *retval = new vector<Double>(ndiv+1);
    Double delta=(xmax-xmin)/ndiv;
    for (Int4 i=0; i<=ndiv; ++i) {
        retval->at(i)=xmin+delta*i;
    }
    return *retval;
}

int main(Int4 argc, Char *argv[]) {
    Double xmin, xmax;
    Int4  ndiv;

    std::cout << "xmin="; std::cin >> xmin; std::cout << xmin << endl;
    std::cout << "xmax="; std::cin >> xmax; std::cout << xmax << endl;
    std::cout << "ndiv="; std::cin >> ndiv; std::cout << ndiv << endl;

    vector<Double> v=initVector(xmin, xmax, ndiv);
    VectorArrayConv conv = *(new VectorArrayConv());

    Double *v1         = conv.vectorToArray(v);
    vector<Double> *v2 = conv.arrayToVector(v1, v.size());

    for (UInt4 i=0; i<v.size(); ++i) {
        std::cout << i << " v=" << v.at(i) << " v1=" << v1[i] << " v2=" << v2->at(i) << endl;
    }
    for (UInt4 i=0; i<v2->size(); ++i) {
        std::cout << i << " v=" << v.at(i) << " v1=" << v1[i] << " v2=" << v2->at(i) << endl;
    }

    exit(EXIT_SUCCESS);
}
