#include "Header.hh"
#include "MatrixUtil.hh"

#include <cstdlib>
#include <ostream>
#include <iostream>

#include "gsl/gsl_matrix.h"
#include "VectorGSLVectorConv.hh"

vector< vector<Double> > *initMatrix(UInt4 n) {
    vector< vector<Double> > *retval=new vector< vector<Double> >(n, *(new vector<Double>(n)));

    for (UInt4 i=0; i<n; ++i) {
        for (UInt4 j=0; j<n; ++j) {
            retval->at(i).at(j)=static_cast<Double>(i+j);
        }
    }
    return retval;
}

testOutput(ostream &os, vector< vector<Double> > *m, gsl_matrix *gslM, vector<Double> rowNo) {
}

void clearMatrix(vector< vector<Double> > &m) {

    for (UInt4 i=0; i<m.size(); ++i) {
        m.at(i).clear();
    }
    m.clear();
}

Int4 main(Int4 argc, Char *argv[]) {

    MatrixUtil *util = new MatrixUtil();
    vector< vector<Double> > *m=initMatrix(10);

    vector<Int4> *rowNo=new vector<Int4>(m->size());
    for (UInt4 i=0; i<m->size(); ++i) {
        rowNo->at(i)=100*i;
    }

    VectorGSLVectorConv *conv=new VectorGSLVectorConv();
    gsl_matrix *gslM=conv->matrixToGSLMatrix(*m);

    UInt4 indent;
    UInt4 from, to;
    UInt4 shortPrec, longPrec;
    UInt4 lineLength;


    indent=8;
    from=0;
    to=10;
    shortPrec=5;
     longPrec=15;
    lineLength=150;
   
    std::clog<< " without row No. && without column No." << endl;
    util->outputMatrix(std::clog, indent, *m, from, to, from, to, true,  shortPrec, false, false, lineLength);
    std::clog<< " without row No. && with    column No." << endl;
    util->outputMatrix(std::clog, indent, *m, from, to, from, to, true,  shortPrec, false, true,  lineLength);
    std::clog<< " with    row No. && without column No." << endl;
    util->outputMatrix(std::clog, indent, *m, from, to, from, to, true,  shortPrec, true,  false, lineLength);
    std::clog<< " with    row No. && with    column No." << endl;
    util->outputMatrix(std::clog, indent, *m, from, to, from, to, true,  shortPrec, true,  true,  lineLength);

    std::clog<< " without row No. && without column No." << endl;
    util->outputMatrix(std::clog, indent, *m, from, to, from, to, false, longPrec, false, false, lineLength);
    std::clog<< " without row No. && with    column No." << endl;
    util->outputMatrix(std::clog, indent, *m, from, to, from, to, false, longPrec, false, true,  lineLength);
    std::clog<< " with    row No. && without column No." << endl;
    util->outputMatrix(std::clog, indent, *m, from, to, from, to, false, longPrec, true,  false, lineLength);
    std::clog<< " with    row No. && with    column No." << endl;
    util->outputMatrix(std::clog, indent, *m, from, to, from, to, false, longPrec, true,  true,  lineLength);

    std::clog<< " with user's row No. && without column No." << endl;
    util->outputMatrixWithUsersRowHeader(std::clog, indent, *m, *rowNo, from, to, from, to, true,   shortPrec, false, lineLength);
    std::clog<< " with user's row No. && with    column No." << endl;
    util->outputMatrixWithUsersRowHeader(std::clog, indent, *m, *rowNo, from, to, from, to, true,   shortPrec, true,  lineLength);
    std::clog<< " with user's row No. && without column No." << endl;
    util->outputMatrixWithUsersRowHeader(std::clog, indent, *m, *rowNo, from, to, from, to, false,  longPrec,  false, lineLength);
    std::clog<< " with user's row No. && with    column No." << endl;
    util->outputMatrixWithUsersRowHeader(std::clog, indent, *m, *rowNo, from, to, from, to, false,  longPrec,  true,  lineLength);

    std::clog<< " without row No. && without column No., gsl_matrix" << endl;
    util->outputMatrix(std::clog, indent, gslM, 0, 10, 0, 10, true,  5, false, false, 150);
    std::clog<< " without row No. && with    column No., gsl_matrix" << endl;
    util->outputMatrix(std::clog, indent, gslM, 0, 10, 0, 10, true,  5, false, true,  150);
    std::clog<< " with    row No. && without column No., gls_matrix" << endl;
    util->outputMatrix(std::clog, indent, gslM, 0, 10, 0, 10, true,  5, true,  false, 150);
    std::clog<< " with    row No. && with    column No., gsl_matrix" << endl;
    util->outputMatrix(std::clog, indent, gslM, 0, 10, 0, 10, true,  5, true,  true,  150);

    std::clog<< " without row No. && without column No., gsl_matirx" << endl;
    util->outputMatrix(std::clog, indent, gslM, 0, 10, 0, 10, false, 15, false, false, 150);
    std::clog<< " without row No. && with    column No., gsl_matirx" << endl;
    util->outputMatrix(std::clog, indent, gslM, 0, 10, 0, 10, false, 15, false, true,  150);
    std::clog<< " with    row No. && without column No., gsl_matirx" << endl;
    util->outputMatrix(std::clog, indent, gslM, 0, 10, 0, 10, false, 15, true,  false, 150);
    std::clog<< " with    row No. && with    column No., gsl_matirx" << endl;
    util->outputMatrix(std::clog, indent, gslM, 0, 10, 0, 10, false, 15, true,  true,  150);

    std::clog<< " with user's row No. && without column No., gsl_matrix" << endl;
    util->outputMatrixWithUsersRowHeader(std::clog, indent, gslM, *rowNo, from, to, from, to, true,   shortPrec, false, lineLength);
    std::clog<< " with user's row No. && with    column No., gsl_matrix" << endl;
    util->outputMatrixWithUsersRowHeader(std::clog, indent, gslM, *rowNo, from, to, from, to, true,   shortPrec, true,  lineLength);
    std::clog<< " with user's row No. && without column No., gsl_matrix" << endl;
    util->outputMatrixWithUsersRowHeader(std::clog, indent, gslM, *rowNo, from, to, from, to, false,  longPrec,  false, lineLength);
    std::clog<< " with user's row No. && with    column No., gsl_matrix" << endl;
    util->outputMatrixWithUsersRowHeader(std::clog, indent, gslM, *rowNo, from, to, from, to, false,  longPrec,  true,  lineLength);

    rowNo->clear();
    delete rowNo;
    this->clearMatrix(*m);
    delete m;
    delete util;
    delete conv;
    gsl_matrix_free(gslM);

    return EXIT_SUCCESS;
}
