#ifndef VECTOR_GSL_VECTOR_CONV_H
#define VECTOR_GSL_VECTOR_CONV_H

#include "Header.hh"
#include "gsl/gsl_vector.h"
#include "gsl/gsl_matrix.h"

class AdvVectorGSLVectorConv {

    public:
        /** convert a vector<Double> to a GSL vector */
        gsl_vector *vectorToGSLVector(const vector<Double> &v);

        /** convert a vector<Double> to a GSL vector */
        vector<Double> *gslVectorToVector(const gsl_vector *v);

        /** convert a vector< vector<Double> > to a GSL matrix */
        gsl_matrix *matrixToGSLMatrix(const vector< vector<Double> > &m);

        /** convert a GSL matrix to a vector< vector<Double> > */
        vector< vector<Double> > *gslMatrixToMatrix(const gsl_matrix *m);

};
#endif //  VECTOR_GSL_VECTOR_CONV_H
