#include "AdvVectorGSLVectorConv.hh"

/** 
 *  convert a STL vector to a GSL vector
 *
 *  \param[in] v  a STL vector
 *  \return GSL vector
 */
gsl_vector *AdvVectorGSLVectorConv::vectorToGSLVector(const vector<Double> &v) {

    gsl_vector *gslV=NULL;

    gslV=gsl_vector_alloc(v.size());
    size_t ct=0;
    for (std::vector<Double>::const_iterator ve=v.begin(); ve != v.end(); ++ve) {
        gsl_vector_set(gslV, ct, *ve);
        ++ct;
    }
    return gslV;
}

/**
 *  convert a GSL vector to a STL vector
 *
 *  \param[in] v a GSL vector
 *  \return STL vector
 */
vector<Double> *AdvVectorGSLVectorConv::gslVectorToVector(const gsl_vector *v) {
    vector<Double>  *stlV=NULL;

    stlV=new vector<Double>(v->size);
    for (size_t i=0; i<v->size; ++i) {
        stlV->at(i)=gsl_vector_get(v, i);
    }
    return stlV;
}

/**
 *  convert a matrix to GSL matrix
 *
 *  \param[in] m a matrix (vector< vector<Double> >)
 *  \return a GSL matrix
 */
gsl_matrix *AdvVectorGSLVectorConv::matrixToGSLMatrix(const vector< vector<Double> > &m) {
    gsl_matrix *gslM=NULL;

    gslM=gsl_matrix_alloc(m.size(), m.at(0).size());
    for (size_t i=0; i<m.size(); ++i) {
        for (size_t j=0; j<m.at(0).size(); ++j) {
            gsl_matrix_set(gslM, i, j, m.at(i).at(j));
        }
    }
    return gslM;
}

/**
 *  convert a GSL matrix to a STL matrix
 *
 *  \param[in] m a GSL matrix
 *  \return a STL matrix
 */
vector< vector<Double> > *AdvVectorGSLVectorConv::gslMatrixToMatrix(const gsl_matrix *m) {
    vector< vector<Double> > *stlM=NULL;

    stlM=new vector< vector<Double> >(m->size1, *(new vector<Double>(m->size2)));
    for (size_t i=0; i<m->size1; ++i) {
        for (size_t j=0; j<m->size2; ++j) {
            stlM->at(i).at(j)=gsl_matrix_get(m, i, j);
        }
    }
    return stlM;
}
