#ifndef EXT_VECTOR_TOOL
#define EXT_VECTOR_TOOL

#include "Header.hh"
#include "VectorTool.hh"

class AdvExtVectorTool : public VectorTool {

    public:
        AdvExtVectorTool();
        virtual ~AdvExtVectorTool();

        /** transform Double array to vector<Double> */
        vector<Double> *arrayToVectorP(const Double *array, const UInt4 n);

        /** transform Double array (1d) to vector< vector<Double> ) */
        vector< vector<Double> > *arrayToMatrixP(const Double *attay, const UInt4 rN, const UInt4 cN);

        /** transform Double array (1d) to vector< vector<Double> ) */
        vector< vector<Double> > ArrayToMatrix(const Double *attay, const UInt4 rN, const UInt4 cN);

        /** transform vector< vector<Double> > to Double array (1d) */
        Double *MatrixTo1DArray(const vector< vector<Double> > &m);

};
#endif // EXT_VECTOR_TOOL
