#ifndef CONVDECONVPRE
#define CONVDECONVPRE

#include "Header.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"

#include "AdvMultiDataMethod.hh"
#include "AdvMultiDataOperationBase.hh"


class AdvConvDeconvPre : public AdvMultiDataOperationBase {
    private:
        static const string className; // = string("AdvConvDeconvPre");

    public:
        AdvConvDeconvPre();

        AdvConvDeconvPre(ElementContainerArray *src);
#ifndef SWIGPYTHON
        AdvConvDeconvPre(ElementContainerArray *src, AdvMultiDataMethod  *method);
#endif
        AdvConvDeconvPre(ElementContainerArray *src, const AdvMethodType &methodType);
        AdvConvDeconvPre(ElementContainerArray *src, const string     &methodName);

        /**
         *  constructor
         */
#ifndef SWIGPYTHON
        AdvConvDeconvPre(ElementContainerArray *src, AdvMultiDataMethod  *method,     const Double xLower, const Double xUpper);
#endif
        AdvConvDeconvPre(ElementContainerArray *src, const AdvMethodType &methodType, const Double xLower, const Double xUpper);
        AdvConvDeconvPre(ElementContainerArray *src, const string     &methodName, const Double xLower, const Double xUpper);

        /**
         *  constructor
         */
#ifndef SWIGPYTHON
        AdvConvDeconvPre(ElementContainerArray *src, AdvMultiDataMethod  *method,     const UInt4 lower, const UInt4 upper);
#endif
        AdvConvDeconvPre(ElementContainerArray *src, const AdvMethodType &methodType, const UInt4 lower, const UInt4 upper);
        AdvConvDeconvPre(ElementContainerArray *src, const string     &methodName, const UInt4 lower, const UInt4 upper);

        /**
         *  destructor
         */
        ~AdvConvDeconvPre();


        void execute();

        void fit() { this->execute(); };

        Bool isFitting() { return false; };

        void stopFit() {};

        ElementContainer      getResult(UInt4 i);
        ElementContainerArray getResult();

        /////////////////////  dummy //////////////////////
        Double chiSq() { return 0.0; };
        ElementContainerArray  getResultComponents(UInt4) { return *(new ElementContainerArray()); };
        ElementContainerMatrix getResultComponents() { return *(new ElementContainerMatrix()); };
        AdvParamSet*              getLatestConvergenceStat() const { return new AdvParamSet(); };

};

#endif // CONVDECONV
