#ifndef AdvParamSet_h
#define AdvParamSet_h

#include <string.h>
#include <list>
#include <map>
#include <string>
#include <cstdio>
#include <ios>
#include <ostream>
#include <iomanip>
#include <stdexcept>

#include "Header.hh"
#include "CppToPython.hh"

#include "AdvMessage.hh"
#include "AdvPeakData.hh"
#include "AdvFuncBase.hh"



/** 
 *  container for Double type matrix
 *
 *  \author TANIMORI Souichirou, AdvanceSoft Corp.
 *  \version 0.0
 *  \sinse   2.1.14
 */
class AdvParamSet : public AdvMessage {
 private:
    static const string className; // = string(AdvParamSet);

 private:

    /**
     *  container for Bool type parameters
     */
    map<string, Bool> BoolMap;

    /** 
     *  container for Int4 type parameters
     */
    map<string, Int4> Int4Map;

    /**
     *  container for UInt4 type parameters
     */
    map<string, UInt4> UInt4Map;

    /** 
     *  container for Double type parameters
     */
    map<string, Double> DoubleMap;

    /** 
     *  container for Double type vectors/array
     */
    map<string, vector<Double> > vectorMap;

    /** 
     *  container for Double tpye matrices
     */
    map<string, vector< vector<Double> > > matrixMap;


    /**
     *  container for PeakData
     */
    map<string, AdvPeakData> peakDataMap;

    /**
     * list  function
     */
    map<string, vector<AdvFuncBase*> > funcListMap;

    /**
     * list of function lists
     */
    map<string, vector< vector<AdvFuncBase*> > > funcMatrixMap;



 public:
    /**  default constructor */
    AdvParamSet();


    /**  destructor */
    ~AdvParamSet();


    /**  add a Bool type parameter with its key */
    void add(const string key, const Bool value) throw(invalid_argument) ; 

    /**  add a Int4 type parameter with its key */
    void add(const string key, const Int4 value) throw(invalid_argument) ;

    /**  add a UInt4 type parameter with its key */
    void add(const string key, const UInt4 value) throw(invalid_argument) ;

    /**  add a Double type parameter with its key */
    void add(const string key, const Double value) throw(invalid_argument) ;

    /**  add a Double type vector with its key */
    void add(const string key, vector<Double> &value) throw(invalid_argument) ;

    void add(const string key, PyObject *value) throw (invalid_argument) ;

    /**  add a Double type matrix wthe its key */
    void add(const string key, vector< vector<Double> > value) throw(invalid_argument) ;

    /**  add a PeakData type parameter with key */
    void add(const string key, AdvPeakData peakData) throw(invalid_argument) ;

    void add(const string key, vector<AdvFuncBase*>) throw(invalid_argument) ;

    void add(const string key, vector< vector<AdvFuncBase*> >) throw(invalid_argument) ;

    /**  erase the data with the given key */
    void erase(const string &key);

    /**  replace the value of the Bool type data with the given key */
    void replace(const string &key, const Bool value) throw(invalid_argument) ;

    /**  replace the value of the Int4 type data with the given key */
    void replace(const string &key, const Int4 value) throw(invalid_argument) ;

    /**  replace the value of the UInt4 type data with the given key */
    void replace(const string &key, const UInt4 value) throw(invalid_argument) ;

    /**  replace the value of the Double type data with the given key */
    void replace(const string &key, const Double value) throw(invalid_argument) ;


    /**  replace the value of the Double type vector/array with the given key */
    void replace(const string &key, vector<Double> value) throw(invalid_argument) ;

    void replace(const string &key, PyObject *value) throw(invalid_argument) ;

    /**  replace the specified component of the vector with key */
    void replace(const string &key, const UInt4 i, const Double value) throw(invalid_argument, out_of_range) ;


    /**  replace the value of the Double type matrix with the given key */
    void replace(const string &key, vector< vector<Double> > value) throw(invalid_argument) ;

    /**  replace the specified component of the matrix with key */
    void replace(const string &key, UInt4 i, UInt4 j, Double value) throw(invalid_argument, out_of_range) ;

    /**  replace PeakData type parameter with key */
    void replace(const string &key, AdvPeakData value) throw(invalid_argument) ;

    /** replace the function list with the given key */
    void replace(const string &key, vector<AdvFuncBase*> value) throw(invalid_argument) ;

    /** replace the specified component of the function list with given key */
    void replace(const string &key, const UInt4 i, AdvFuncBase *value) throw(invalid_argument, out_of_range) ;

    void replace(const string &ket, vector< vector<AdvFuncBase*> > value) throw(invalid_argument) ;

    void replace(const string &key, UInt4 i, UInt4 j, AdvFuncBase *value) throw(invalid_argument, out_of_range) ;

    /**  dump the set of parameters to stdout */
    void dump();

    /** true if no data is registed */
    Bool empty() const ;

    /**  get the value of the Bool type data with the given key */
    Bool getBool(const string &Key) const ;


    /**  get the value of the Int4 type data with the given key */
    Int4 getInt4(const string &key) const ;

    /**  get the value of the UInt4 type data with the given key */
    UInt4 getUInt4(const string &key) const ;

    /**  get the value of the Double type data with the given key */
    Double getDouble(const string &key) const ;

    /**  get the Double type  vector with the given key */
    vector<Double> getVector(const string &key) const ;

    /**  get the value of the specified component of the Double type  vector with the given key */
    Double getDouble(const string &key, const UInt4 i) const ;

    /** get size of value with specified key */
    UInt4 getVectorSize(const string &key) const ;

    /**  get the Double type  matrix with the given key */
    vector< vector<Double> > getMatrix(const string &key) const ;

    /**  get the value of the specified component (i,j) of the Double type matrix with the given key */
    Double getDouble(const string &key, UInt4 i, UInt4 j) const ;

    /**  get the size of the row of the matrix with key */
    UInt4 getRowSize(const string &key) const ;

    /**  get the size of column of the matrix with key */
    UInt4 getColumnSize(const string &key) const ;

    /**  get the value of PeakData type paarameter with the given key. */
    AdvPeakData getPeakData(const string &key) const ;

    /** get a list of functions */
    vector<AdvFuncBase*> getFuncList(const string &key) const ;

    /** get a pointer to a list of functions */
    vector<AdvFuncBase*> *getFuncListP(const string &key) const ;

    vector< vector<AdvFuncBase*> > getFuncMatrix(const string &key) const ;

    /**  return a list of keys registed */
    vector<string> getKeyList() const ;

    /**  key (and the value(s) for the parameter with the key) is contained the param set */
    Bool contain(const string &key) const ;

};

#endif // Manyo_develop_operation_AdvParamSet_h

