#!/usr/bin/python

import Manyo
import BuildInFunc



def outputHeader(width):
    print("x".rjust(width), "eval".rjust(width), "der1st".rjust(width), "der2nd".rjust(width), "g[0]".rjust(width), "g[1]".rjust(width), "g[02".rjust(width))

def outputValues(f, x, param, width):
    v =  f.eval(x, param)
    d1= f.der1st(x, param)
    d1= f.der2st(x, param)
    g = f.gradient(x, param)
    print(str(x).rjust(width), str(v).rjust(width), str(d1).rjust(width), str(d2).rjust(width), str(g[0]).rjust(width), str(g[1]).rjust(width), str(g[2]).rjust(width))

outputWidth=23
paramForGaussian=Manyo.DoubleVector();
paramForGaussian.push_back(1.0)  # height
paramForGaussian.push_back(0.0)  # cneter
paramForGaussian.push_back(1.0)  # width

xmin=-5.0
xmax=5.0
div=100
delta=(xmax-xmin)/div

f=BuildInFunc.Gaussian()

outputHeader(outputWidth)
for i in range(div+1):
    x=xmin+delta*i
    outputValues(f, x, paramForGaussian, outputWidth)
    
