#ifndef PSEUDO_VOIGT_1_H
#define PSEUDO_VOIGT_1_H 1

#include "AdvFuncBase.hh"
#include "AdvGaussian.hh"
#include "AdvLorentzian.hh"

#define NumberOfParamForPseudoVoigt1 4U

/**
 *  Pseudo-Voigt (I) function
 */
class AdvPseudoVoigt1 : public AdvFuncBase {

    private:
        AdvGaussian gaussian;
        AdvLorentzian lorentzian;

    public:
        /** default constructor */
        AdvPseudoVoigt1() ;

        /** destructor */
        ~AdvPseudoVoigt1() ;

        /** evaluate the value of the function */
        Double eval(const Double x, const Double h, const Double c, const Double w, const Double m);
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const Double h, const Double c, const Double w, const Double m);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const Double h, const Double c, const Double w, const Double m);

#ifdef USE_POINTER
        /** evaluate the value of the function */
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const Double *p);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const Double *p);
        /** evaluate the gradient of the function for parameters */
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        /** evaluate the value of the function */
        Double eval(const Double x, const vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const vector<Double> &p);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const vector<Double> &p);
        /** evaluate the gradient of the function for parameters */
        vector<Double> gradient(const Double x, const vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR
};

#endif
