#ifndef CONSTANTCONV_HH
#define CONSTANTCONV_HH

#include "Header.hh"
#include "AdvFuncBase.hh"

#define NumberOfParamForConstantConv 1

class AdvConstantConv : public AdvFuncBase {

    public:
        AdvConstantConv();
        ~AdvConstantConv();

#ifdef USE_POINTER
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double *p);
        Double der2nd(const Double x, const Double *p);
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        Double eval(const Double x, const vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const vector<Double> &p);
        Double der2nd(const Double x, const vector<Double> &p);
        vector<Double> gradient(const Double x, const vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

};
#endif // CONSTANT_HH

