#include "AdvConstantConv.hh"

#define NumberOfParamForConstant 1

AdvConstantConv::AdvConstantConv() : AdvFuncBase(string("constant conv"), string("cc"), NumberOfParamForConstantConv)  {
}

AdvConstantConv::~AdvConstantConv() {
}

#ifdef USE_POINTER
Double AdvConstantConv::eval(const Double x, const Double *p) {
    return p[0];
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvConstantConv::der1st(const Double x, const Double *p) {
    return 0.0;
}

Double AdvConstantConv::der2nd(const Double x, const Double *p) {
    return 0.0;
}

Double *AdvConstantConv::gradient(const Double x, const Double *p) {
    Double *v=new Double[NumberOfParamForConstant];
    v[0]=1.0;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
Double AdvConstantConv::eval(const Double x, const vector<Double> &p) {
    return p.at(0);
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvConstantConv::der1st(const Double x, const vector<Double> &p) {
    return 0.0;
}

Double AdvConstantConv::der2nd(const Double x, const vector<Double> &p) {
    return 0.0;
}

vector<Double> AdvConstantConv::gradient(const Double x, const vector<Double> &p) {
    vector<Double> *v=new vector<Double>(1);
    v->at(0)=1.0;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

