#include "AdvVectorGSLVectorConv.hh"

/** 
 *  convert a STL std::vector to a GSL std::vector
 *
 *  \param[in] v  a STL std::vector
 *  \return GSL std::vector
 */
gsl_vector *AdvVectorGSLVectorConv::vectorToGSLVector(const std::vector<Double> &v) {

    gsl_vector *gslV=NULL;

    gslV=gsl_vector_alloc(v.size());
    size_t ct=0;
    for (std::vector<Double>::const_iterator ve=v.begin(); ve != v.end(); ++ve) {
        gsl_vector_set(gslV, ct, *ve);
        ++ct;
    }
    return gslV;
}

/**
 *  convert a GSL std::vector to a STL std::vector
 *
 *  \param[in] v a GSL std::vector
 *  \return STL std::vector
 */
std::vector<Double> *AdvVectorGSLVectorConv::gslVectorToVector(const gsl_vector *v) {
    std::vector<Double>  *stlV=NULL;

    stlV=new std::vector<Double>(v->size);
    for (size_t i=0; i<v->size; ++i) {
        stlV->at(i)=gsl_vector_get(v, i);
    }
    return stlV;
}

/**
 *  convert a matrix to GSL matrix
 *
 *  \param[in] m a matrix (std::vector< std::vector<Double> >)
 *  \return a GSL matrix
 */
gsl_matrix *AdvVectorGSLVectorConv::matrixToGSLMatrix(const std::vector< std::vector<Double> > &m) {
    gsl_matrix *gslM=NULL;

    gslM=gsl_matrix_alloc(m.size(), m.at(0).size());
    for (size_t i=0; i<m.size(); ++i) {
        for (size_t j=0; j<m.at(0).size(); ++j) {
            gsl_matrix_set(gslM, i, j, m.at(i).at(j));
        }
    }
    return gslM;
}

/**
 *  convert a GSL matrix to a STL matrix
 *
 *  \param[in] m a GSL matrix
 *  \return a STL matrix
 */
std::vector< std::vector<Double> > *AdvVectorGSLVectorConv::gslMatrixToMatrix(const gsl_matrix *m) {
    std::vector< std::vector<Double> > *stlM=NULL;

    stlM=new std::vector< std::vector<Double> >(m->size1, *(new std::vector<Double>(m->size2)));
    for (size_t i=0; i<m->size1; ++i) {
        for (size_t j=0; j<m->size2; ++j) {
            stlM->at(i).at(j)=gsl_matrix_get(m, i, j);
        }
    }
    return stlM;
}
