#include "AdvPolynomial2.hh"

#define NumberOfParamForPolynomial2 1

AdvPolynomial2::AdvPolynomial2() : AdvFuncBase(std::string("polynomial2"), std::string("p2"), NumberOfParamForPolynomial2)  {
}

AdvPolynomial2::~AdvPolynomial2() {
}

#ifdef USE_POINTER
Double AdvPolynomial2::eval(const Double x, const Double *p) {
    return p[0]*x*x;
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvPolynomial2::der1st(const Double x, const Double *p) {
    return 2*p[0]*x;
}

Double AdvPolynomial2::der2nd(const Double x, const Double *p) {
    return 2*p[0];
}

Double *AdvPolynomial2::gradient(const Double x, const Double *p) {
    Double *v=new Double[NumberOfParamForPolynomial2];
    v[0]=x*x;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
Double AdvPolynomial2::eval(const Double x, const std::vector<Double> &p) {
    return p.at(0)*x*x;
}

#ifdef HAVE_DIFFERENTIAL_MEMBER
Double AdvPolynomial2::der1st(const Double x, const std::vector<Double> &p) {
    return 2*p.at(0)*x;
}

Double AdvPolynomial2::der2nd(const Double x, const std::vector<Double> &p) {
    return 2*p.at(0);
}

std::vector<Double> AdvPolynomial2::gradient(const Double x, const std::vector<Double> &p) {
    std::vector<Double> *v=new std::vector<Double>(1);
    v->at(0)=x*x;
    return *v;
}
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_VECTOR

