#ifndef PEAK_DATA_H
#define PEAK_DATA_H

#include <cstdio>
#include <iostream>
#include <iomanip>
#include <ostream>
//#include <list>
#include <vector>

#include "gsl/gsl_vector.h"

/* from manyo-lib */
#include "Header.hh"
#include "CppToPython.hh"

#include "AdvPeak.hh"
#include "AdvFuncBase.hh"

/**  a set of peaks
 *
 *  @author TANIMORI Souyichirou, AdvanceSoft Corp.
 *  @version 0.0
 *  @sice    0.0
 */
class AdvPeakData {

    protected:
        /** a container of peaks */
        std::vector<AdvPeak> peakList;

        /* a list of fitting functions */
        //std::vector< std::vector<FuncBase*> > funcList;

    public:
        /**  constructor  */
        AdvPeakData();

        /**  copy constructor  */
        AdvPeakData(const AdvPeakData &p);

        /**  destructor  */
        ~AdvPeakData();

        /**  operator =  */
        AdvPeakData operator = (const AdvPeakData &p);

        /**  add a peak  */
        void add(AdvPeak peak);

        /**  add a peak  */
        void add(const AdvPeakType type, const Double x, const Double h, const Double w, const Double xl, const Double xu) ;

        /**  clear all data  */
        void clear();

        /**  erase i-th. peak data  */
        void erase(const UInt4 i);

        /**  std::vectorise  */
        std::vector<Double> toVector();

        /** to python list */
        PyObject *toPyList();

        /**  toFullVector()  */
        std::vector<Double> toFullVector();

        /**  size of array  */
        UInt4 sizeOfArray();

        /**  toArray  */
        Double *toArray();

        /**  size of array  */
        UInt4 sizeOfFullArray();

        /** serialize as all data of each peak as array */
        Double *toFullArray();

        /** serialize each peaks as gsl_vector */
        gsl_vector *toGslVector();

        /** serialize all data of each peak as gsl_vector */
        gsl_vector *toFullGslVector();

        /** output to stdout */
        void Dump();

        /**
         *  @retval number of peaks
         */
        UInt4 size() const ;

        /**
         *  @retval
         */
        AdvPeak getPeak(const UInt4 i) const ;


        /**
         *
         */
        //std::string getFuncData(UInt4 peakNo);
};

#endif
