#ifndef MULTI_DATA_PEAK_FIT_H
#define MULTI_DATA_PEAK_FIT_H

#include "Header.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"

#include "AdvMultiDataMethod.hh"
#include "AdvMultiDataOperationBase.hh"

/**
 *
 */
class AdvMultiDataPeakFit : public AdvMultiDataOperationBase {
    private:
        static const std::string className; // = std::string("AdvMultiDataPeakFit");

    public:
        /**
         *  constructor
         */
        AdvMultiDataPeakFit();

        AdvMultiDataPeakFit(ElementContainerArray *src);
#ifndef SWIGPYTHON
        AdvMultiDataPeakFit(ElementContainerArray *src, AdvMultiDataMethod  *method);
#endif
        AdvMultiDataPeakFit(ElementContainerArray *src, const AdvMethodType &methodType);
        AdvMultiDataPeakFit(ElementContainerArray *src, const std::string     &methodName);

        /**
         *  constructor
         */
#ifndef SWIGPYTHON
        AdvMultiDataPeakFit(ElementContainerArray *src, AdvMultiDataMethod  *method,     const Double xLower, const Double xUpper);
#endif
        AdvMultiDataPeakFit(ElementContainerArray *src, const AdvMethodType &methodType, const Double xLower, const Double xUpper);
        AdvMultiDataPeakFit(ElementContainerArray *src, const std::string     &methodName, const Double xLower, const Double xUpper);

        /**
         *  constructor
         */
#ifndef SWIGPYTHON
        AdvMultiDataPeakFit(ElementContainerArray *src, AdvMultiDataMethod  *method,     const UInt4 lower, const UInt4 upper);
#endif
        AdvMultiDataPeakFit(ElementContainerArray *src, const AdvMethodType &methodType, const UInt4 lower, const UInt4 upper);
        AdvMultiDataPeakFit(ElementContainerArray *src, const std::string     &methodName, const UInt4 lower, const UInt4 upper);

        /**
         *  destructor
         */
        ~AdvMultiDataPeakFit();

        /**
         *  execute peak fit
         */
        void execute();

        /**
         *  begin to fit
         */
        void fit() { this->method->toInnerForm(*(this->source), this->domains, this->param); this->method->fit(); };

        /**
         *  @retval true if fitting does not finish
         */
        Bool isFitting() { return this->method->isFitting(); };

        /**
         *  stop to fit
         */
        void stopFit() { this->method->stopFit(); }

        /**
         *  evaluate the values of functions
         */
        void eval() { this->method->eval(); };


        Double chiSq();

        AdvParamSet *getLatestConvergenceStat() const ;


        /** get evaluated values of the i-th. fitting function as ElementContainerArray.
         */
       ElementContainer getResult(UInt4 i);

        /** get evaluated values of all fitting functions for multi-data fitting as ElementContainerArray.
         */
       ElementContainerArray getResult();

       /** get evaluated values of the i-th. component functions for single data fitting as ElementContainerArray
        *
        */
       ElementContainerArray getResultComponents(UInt4 i);

        /** get evaluated values of all components functions for multi-data fitting as ElementContainerArray.
         */
       ElementContainerMatrix getResultComponents();
};

#endif
