#ifndef LEVMAR_CONTROL
#define LEVMAR_CONTROL

//#ifdef SWIGPYTHON
//class AdvLevmarControl;
//#else // SWIGPYTHON

#include "Header.hh"

#include "AdvParamSet.hh"
#include "AdvLevmarConsts.hh"

/**
 *  control variables to select the routine of Levmar
 */
class AdvLevmarControl : public AdvMessage {
    private:
        static const std::string className; // std::string("AdvLevmarControl");

    public:
        /** constrain type */
        AdvLevmarConsts::Constrain constrain;
        /** flag for numerical differential */
        Bool useNumericalDiff;
        /** the kind of numerical differential method */
        AdvLevmarConsts::DiffMethod diffMethod;
        /** flag for Least Square method with data weight */
        Bool useDataWeights;

        /* maximum of iteration */
        Int4 maxIterations;
        /* output interval */
        Int4 outputInterval;

        /** capacity of the convergence history buffer */
        UInt4 historyCapacity;

    public:
        /** constructor */
        AdvLevmarControl();
        /** destructor */
        ~AdvLevmarControl();

        /** set default values */
        //AdvParamSet setDefaultParam();
        /** check parameter */
        Bool checkParam(const AdvParamSet &param);
        /** translate into the inner form */
        void toInnerForm(const AdvParamSet &param);
        /** outpur */
        void output();

    private:
        /* check parameter */
        Bool checkConstrainType(   const AdvParamSet &param);
        Bool checkUseNumericalDiff(const AdvParamSet &param);
        Bool checkDiffMethod(      const AdvParamSet &param);
        Bool checkUseDataWeights(  const AdvParamSet &param);
        Bool checkMaxIterations(   const AdvParamSet &param);
        Bool checkOutputInterval(  const AdvParamSet &param);
        Bool checkHistoryCapacity( const AdvParamSet &param);

    public:
        /* translate to inner form */
        AdvLevmarConsts::Constrain  getConstrain(        const AdvParamSet &param);
    private:
        Bool                     getUseNumericalDiff( const AdvParamSet &param);
        AdvLevmarConsts::DiffMethod getDiffMethod(       const AdvParamSet &param);
        Bool                     getUseDataWeights(   const AdvParamSet &param);
        Int4                     getMaxIterations(    const AdvParamSet &param);
        Int4                     getOutputInterval(   const AdvParamSet &param);
        UInt4                    getHistoryCapacity(  const AdvParamSet &param);
};

//#endif // SWIGPYTHON

#endif //  LEVMAR_CONTROL
