#include "AdvLevmarConsts.hh"

const std::string AdvLevmarConsts::className=std::string("AdvLevmarConsts");

/**
 *  keys for contrioling AdvLevmarConsts
 */
/** key for the kind of the constrain */
const std::string AdvLevmarConsts::CONSTRAIN         =std::string("constrain");
/** key for the flag of the numerical differential Jaccobian */
const std::string AdvLevmarConsts::USE_NUMERICAL_DIFF=std::string("use numerical diff");
/** key for the method of numerical differentiation */
const std::string AdvLevmarConsts::DIFF_METHOD       =std::string("diff method");

/** key for the flag of using data weights */
const std::string AdvLevmarConsts::USE_DATA_WEIGHTS=std::string("use data weights");

/** key for maxmum iterations */
const std::string AdvLevmarConsts::MAX_ITERATIONS     =std::string("max iterations");
/** key for outpur interval */
const std::string AdvLevmarConsts::OUTPUT_INTERVAL = std::string("output interval");

/** key for the depth for convergence history */
const std::string AdvLevmarConsts::HISTORY_CAPACITY = std::string("history capacity");

/**
 *  key for input data for fitting using AdvLevmarConsts
 */
/** key for fitting function */
const std::string AdvLevmarConsts::FUNCTIONS= std::string("functions");

/** key for data mask */
const std::string AdvLevmarConsts::MASK = std::string("maxk");

/** keys for a set of values of fitting parameters */
const std::string AdvLevmarConsts::INITIAL_PARAM_VALUES=std::string("initial param values");

const std::string AdvLevmarConsts::PARAMETER_VALUES    =std::string("parameter values");

const std::string AdvLevmarConsts::LINK_IDS    =std::string("link ids");

/** key for a set of the refference data */
const std::string AdvLevmarConsts::REFERENCE_VALUES  =std::string("reference values");

/** keys for lower bound of box constrains */
const std::string AdvLevmarConsts::LOWER_BOUNDS      =std::string("lower bounds");
/** keys for upper bound of box constrains */
const std::string AdvLevmarConsts::UPPER_BOUNDS      =std::string("upper bounds");
/** key for weights of box constrains */
const std::string AdvLevmarConsts::BOX_WEIGHTS       =std::string("box weights");
/** key for linear equations */
const std::string AdvLevmarConsts::EQUATIONS         =std::string("equations");
/** key for linear inequalities */
const std::string AdvLevmarConsts::INEQUALITIES      =std::string("inequalites");

/** key for scaling factor */
const std::string AdvLevmarConsts::SCALING_FACTOR    =std::string("scaling factor");
/** key for threshold values for stopping conditions */
const std::string AdvLevmarConsts::TOLERANCE         =std::string("tolerance");
const std::string AdvLevmarConsts::RELATIVE_TOLERANCE=std::string("relative tolerance");
const std::string AdvLevmarConsts::GRADIENT_TOLERANCE=std::string("gradient tolerance");

const std::string AdvLevmarConsts::RESIDU_ERR_THRESH=std::string("residu. err. thresh");
const std::string AdvLevmarConsts::GRADIENT_THRESH  =std::string("gradient thresh");
const std::string AdvLevmarConsts::PARAM_DIFF_THRESH=std::string("param. diff. thresh");

/** key for step width for numerical differential Jaccobian */
const std::string AdvLevmarConsts::DIFF_DELTA        =std::string("diff delta");


/** key for current iterations */
const std::string AdvLevmarConsts::ITERATION_COUNT    =std::string("iteration count");
/** key for termination stat */
const std::string AdvLevmarConsts::TERMINATION_STAT   =std::string("termination stat");
/** key for R-factor */
const std::string AdvLevmarConsts::R_FACTOR           =std::string("R factor");
/** key for residual error norm */
const std::string AdvLevmarConsts::RESIDUAL_ERR_NORM  =std::string("residual error norm");
/** key for gradient norm */
const std::string AdvLevmarConsts::GRADIENT_NORM      =std::string("gradiend norm");
/** key for parameter difference */
const std::string AdvLevmarConsts::PARAM_DIFF_NORM    =std::string("param diff norm");
/** key for parameter errors */
const std::string AdvLevmarConsts::PARAM_ERRORS       =std::string("param errors");
/** key for covariance matrix */
const std::string AdvLevmarConsts::COVARIANCE_MATRIX  =std::string("covariance matrix");
/** mu ratio, i.e. mu/max{ [J^T J]_ii; 0<=i < the number of fitting parameters} */
const std::string AdvLevmarConsts::MU_RATIO = std::string("mu ratio");
/** the number times of function evaluations */
const std::string AdvLevmarConsts::FUNCTION_EVALUATIONS  = std::string("function evaluations");
/** the number times of Jacobian evaluations */
const std::string AdvLevmarConsts::JACOBIAN_EVALUATIONS  = std::string("Jacobian evaluations");
/** the number times of linear systems solved */
const std::string AdvLevmarConsts::LINEAR_SYSTEMS_SOLVED = std::string("linear systems solved");
/** iteration time */
const std::string AdvLevmarConsts::ITERATION_TIME= std::string("iteration time");

/*
 *  default values of parametes with keys
 */
/** default constrain */
const AdvLevmarConsts::Constrain  AdvLevmarConsts::DEFAULT_CONSTRAIN=AdvLevmarConsts::BOX;

/** default value of the flag to use numerical differential for evaluating Jacobian */
const Bool               AdvLevmarConsts::DEFAULT_USE_NUMERICAL_DIFF=true;
/** default value of the flag to fit with weight */
const Bool               AdvLevmarConsts::DEFAULT_USE_DATA_WEIGHTS  =true;

/** default numerical differential method */
const AdvLevmarConsts::DiffMethod AdvLevmarConsts::DEFAULT_DIFF_METHOD       =AdvLevmarConsts::FORWARD;

/** default value for maximum iterations */
const UInt4 AdvLevmarConsts::DEFAULT_MAX_ITERATIONS  =1000U;
/** default value for output interval */
const UInt4 AdvLevmarConsts::DEFAULT_OUTPUT_INTERVAL =50U;

/** default depth for convergence history */
const UInt4 AdvLevmarConsts::DEFAULT_HISTORY_CAPACITY =50U;

/* for opts[] */
/** default initial value of scaling factro */
const Double AdvLevmarConsts::DEFAULT_SCALING_FACTOR    =LM_INIT_MU;
/** default thresholds to terminate fitteing */
/** \deprecated */
const Double AdvLevmarConsts::DEFAULT_GRADIENT_TOLERANCE=LM_STOP_THRESH;
/** \deprecated */
const Double AdvLevmarConsts::DEFAULT_TOLERANCE         =LM_STOP_THRESH;
/** \deprecated */
const Double AdvLevmarConsts::DEFAULT_RELATIVE_TOLERANCE=LM_STOP_THRESH;

const Double AdvLevmarConsts::DEFAULT_RESIDU_ERR_THRESH =LM_STOP_THRESH;
const Double AdvLevmarConsts::DEFAULT_GRADIENT_THRESH   =LM_STOP_THRESH;
const Double AdvLevmarConsts::DEFAULT_PARAM_DIFF_THRESH =LM_STOP_THRESH;


/** default defference for numerical differential */
const Double AdvLevmarConsts::DEFAULT_DIFF_DELTA        =LM_DIFF_DELTA;

/** constrain std::string */
const std::string AdvLevmarConsts::CONSTRAIN_STR[] = {
    *(new std::string("no constrain")),                                  // Levmar::NO_CONSTRAIN
    *(new std::string("box")),                                           // Levmar::BOX
#ifdef HAVE_LAPACK
    *(new std::string("linear equation")),                               // levmar::LEC
    *(new std::string("linear inequalities")),                           // levmar::LIC
    *(new std::string("box and linear equations")),                      // levmar::BLEC
    *(new std::string("box and linear inequalities")),                   // levmar::BLIC
    *(new std::string("linear equations and linear inequalities")),      // levmar::LEIC
    *(new std::string("box, linear equations and linear inequalities")), // levmar::BLEIC
#endif //  HAVE_LAPACK
};

/** diferentioan method */
const std::string AdvLevmarConsts::DIFF_METHOD_STR[] = {
    *(new std::string("forward")),
    *(new std::string("central")),
};

/** termination reason */
const std::string AdvLevmarConsts::TERMINATION_REASON[] = {
    *(new std::string("")),
    *(new std::string("small inf. norm for gradient (J^T e)")),
    *(new std::string("small L2 norm for parameter difference")),
    *(new std::string("maximum iteraion")),
    *(new std::string("singular matrix. Restart from current p with increased scaling factor")),
    *(new std::string("no further error reduction is possible. Restart with increased scaling factor")),
    *(new std::string("small L2 norm of residual error")),
    *(new std::string("invalid (i.e. NaN or Inf) \"func\" values")),
    *(new std::string("continue")),
    *(new std::string("force-quit by user")),
    *(new std::string("suspend")),
};

