#include "AdvFuncBase.hh"

/**
 *   default constructor
 */
AdvFuncBase::AdvFuncBase() {
    //meaning.clear();
}

/**
 *  copy constructor
 *
 * \param[in] obj AdvFuncBase object
 */
AdvFuncBase::AdvFuncBase(const AdvFuncBase &obj) {
    set(obj.name, obj.symbol, obj.nParam);
}

/**
 *  constructor
 *
 *  \param[in] nParam the number of parameters
 *  \param[in] name   the name of the function
 *  \param[in] symbol the symbol of the function
 */
AdvFuncBase::AdvFuncBase(const std::string name, const std::string symbol, const UInt4 nParam) {
    set(name, symbol, nParam);
}

/**
 *  destructor
 */
AdvFuncBase::~AdvFuncBase() {
    //meaning.clear();
}

/**
 *  set the values for the function
 *
 *  \param[in] nParam the number of parameters
 *  \param[in] name   the name of the function
 *  \param[in] symbol the symbol of the function
 */

void AdvFuncBase::set(const std::string name, const std::string symbol, const UInt4 nParam) {
    this->name=name;
    this->symbol=symbol;
    this->nParam=nParam;
    //this->meaningOfParams=menings
}

/**
 *  output the meta data to the function
 */
void AdvFuncBase::dump() const {
   std::fprintf(stdout, "%-20s %-10s %5u\n", this->name.c_str(), this->symbol.c_str(), this->nParam);
};

/**
 *  get the number of parameters
 */
UInt4 AdvFuncBase::getNumberOfParam() const { return this->nParam; }

/**
 *  get the name of the function
 */
std::string AdvFuncBase::getName() const { return *(new std::string(this->name)); };

/**
 *  get the symbol for the function
 */
std::string AdvFuncBase::getSymbol() const { return *(new std::string(this->symbol)); };
